/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;

public class TermsQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "terms";

    @Inject
    public TermsQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "in"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        boolean disableCoord = false;
        float boost = 1.0f;
        int minimumNumberShouldMatch = 1;
        ArrayList<String> values = Lists.newArrayList();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    String value = parser.text();
                    if (value == null) {
                        throw new QueryParsingException(this.index, "No value specified for terms query");
                    }
                    values.add(value);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("disable_coord".equals(currentFieldName) || "disableCoord".equals(currentFieldName)) {
                disableCoord = parser.booleanValue();
                continue;
            }
            if ("minimum_match".equals(currentFieldName) || "minimumMatch".equals(currentFieldName)) {
                minimumNumberShouldMatch = parser.intValue();
                continue;
            }
            if (!"boost".equals(currentFieldName)) continue;
            boost = parser.floatValue();
        }
        FieldMapper mapper = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            mapper = smartNameFieldMappers.mapper();
        }
        BooleanQuery query = new BooleanQuery(disableCoord);
        for (String value : values) {
            if (mapper != null) {
                query.add(new BooleanClause(mapper.fieldQuery(value, parseContext), BooleanClause.Occur.SHOULD));
                continue;
            }
            query.add((Query)new TermQuery(new Term(fieldName, value)), BooleanClause.Occur.SHOULD);
        }
        query.setBoost(boost);
        if (minimumNumberShouldMatch != -1) {
            query.setMinimumNumberShouldMatch(minimumNumberShouldMatch);
        }
        return QueryParsers.wrapSmartNameQuery(Queries.optimizeQuery(Queries.fixNegativeQueryIfNeeded((Query)query)), smartNameFieldMappers, parseContext);
    }
}

