/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Similarity;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.similarity.DefaultSimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityProviderFactory;

public class SimilarityService
extends AbstractIndexComponent {
    private final ImmutableMap<String, SimilarityProvider> similarityProviders;
    private final ImmutableMap<String, Similarity> similarities;

    public SimilarityService(Index index) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS, (Map<String, SimilarityProviderFactory>)null);
    }

    @Inject
    public SimilarityService(Index index, @IndexSettings Settings indexSettings, @Nullable Map<String, SimilarityProviderFactory> providerFactories) {
        super(index, indexSettings);
        HashMap<String, SimilarityProvider> similarityProviders = Maps.newHashMap();
        if (providerFactories != null) {
            Map<String, Settings> providersSettings = indexSettings.getGroups("index.similarity");
            for (Map.Entry<String, SimilarityProviderFactory> entry : providerFactories.entrySet()) {
                String similarityName = entry.getKey();
                SimilarityProviderFactory similarityProviderFactory = entry.getValue();
                Settings similaritySettings = providersSettings.get(similarityName);
                if (similaritySettings == null) {
                    similaritySettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                SimilarityProvider similarityProvider = similarityProviderFactory.create(similarityName, similaritySettings);
                similarityProviders.put(similarityName, similarityProvider);
            }
        }
        if (!similarityProviders.containsKey("index")) {
            similarityProviders.put("index", new DefaultSimilarityProvider(index, indexSettings, "index", ImmutableSettings.Builder.EMPTY_SETTINGS));
        }
        if (!similarityProviders.containsKey("search")) {
            similarityProviders.put("search", new DefaultSimilarityProvider(index, indexSettings, "search", ImmutableSettings.Builder.EMPTY_SETTINGS));
        }
        this.similarityProviders = ImmutableMap.copyOf(similarityProviders);
        HashMap similarities = Maps.newHashMap();
        for (SimilarityProvider provider : similarityProviders.values()) {
            similarities.put(provider.name(), provider.get());
        }
        this.similarities = ImmutableMap.copyOf(similarities);
    }

    public Similarity similarity(String name) {
        return this.similarities.get(name);
    }

    public Similarity defaultIndexSimilarity() {
        return this.similarities.get("index");
    }

    public Similarity defaultSearchSimilarity() {
        return this.similarities.get("search");
    }
}

