/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cache.filter;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import org.elasticsearch.common.concurrentlinkedhashmap.EvictionListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.cache.filter.support.AbstractWeightedFilterCache;
import org.elasticsearch.index.cache.filter.support.FilterCacheValue;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class IndicesNodeFilterCache
extends AbstractComponent
implements EvictionListener<AbstractWeightedFilterCache.FilterCacheKey, FilterCacheValue<DocSet>> {
    private ConcurrentMap<AbstractWeightedFilterCache.FilterCacheKey, FilterCacheValue<DocSet>> cache;
    private volatile long sizeInBytes;
    private final CopyOnWriteArrayList<EvictionListener<AbstractWeightedFilterCache.FilterCacheKey, FilterCacheValue<DocSet>>> evictionListeners = new CopyOnWriteArrayList();

    public IndicesNodeFilterCache() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    @Inject
    public IndicesNodeFilterCache(Settings settings) {
        super(settings);
        String size = this.componentSettings.get("size", "20%");
        if (size.endsWith("%")) {
            double percent = Double.parseDouble(size.substring(0, size.length() - 1));
            this.sizeInBytes = (long)(percent / 100.0 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().bytes());
        } else {
            this.sizeInBytes = ByteSizeValue.parseBytesSizeValue(size).bytes();
        }
        int weightedSize = (int)Math.min(this.sizeInBytes / 10L, Integer.MAX_VALUE);
        this.cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(weightedSize).weigher(new AbstractWeightedFilterCache.FilterCacheValueWeigher()).listener(this).build();
        this.logger.debug("using [node] filter cache with size [{}]", new ByteSizeValue(this.sizeInBytes));
    }

    public void addEvictionListener(EvictionListener<AbstractWeightedFilterCache.FilterCacheKey, FilterCacheValue<DocSet>> listener) {
        this.evictionListeners.add(listener);
    }

    public void removeEvictionListener(EvictionListener<AbstractWeightedFilterCache.FilterCacheKey, FilterCacheValue<DocSet>> listener) {
        this.evictionListeners.remove(listener);
    }

    public void close() {
        this.cache.clear();
    }

    public ConcurrentMap<AbstractWeightedFilterCache.FilterCacheKey, FilterCacheValue<DocSet>> cache() {
        return this.cache;
    }

    @Override
    public void onEviction(AbstractWeightedFilterCache.FilterCacheKey filterCacheKey, FilterCacheValue<DocSet> docSetFilterCacheValue) {
        for (EvictionListener<AbstractWeightedFilterCache.FilterCacheKey, FilterCacheValue<DocSet>> listener : this.evictionListeners) {
            listener.onEviction(filterCacheKey, docSetFilterCacheValue);
        }
    }
}

