/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.create;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestCreateIndexAction
extends BaseRestHandler {
    @Inject
    public RestCreateIndexAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}", this);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        createIndexRequest = new CreateIndexRequest(request.param("index"));
        if (request.hasContent()) {
            xContentType = XContentFactory.xContentType(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength());
            if (xContentType != null) {
                try {
                    source = XContentFactory.xContent(xContentType).createParser(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength()).mapAndClose();
                    found = false;
                    if (source.containsKey("settings")) {
                        createIndexRequest.settings((Map)source.get("settings"));
                        found = true;
                    }
                    if (source.containsKey("mappings")) {
                        found = true;
                        mappings = (Map)source.get("mappings");
                        for (Map.Entry<K, V> entry : mappings.entrySet()) {
                            createIndexRequest.mapping((String)entry.getKey(), (Map)entry.getValue());
                        }
                    }
                    if (found) ** GOTO lbl41
                    createIndexRequest.settings(source);
                }
                catch (Exception e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        this.logger.warn("Failed to send response", e1, new Object[0]);
                        return;
                    }
                }
            } else {
                try {
                    createIndexRequest.settings(request.contentAsString());
                }
                catch (Exception e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, RestStatus.BAD_REQUEST, new SettingsException("Failed to parse index settings", e)));
                    }
                    catch (IOException e1) {
                        this.logger.warn("Failed to send response", e1, new Object[0]);
                        return;
                    }
                }
            }
        }
lbl41:
        // 7 sources

        createIndexRequest.timeout(request.paramAsTime("timeout", TimeValue.timeValueSeconds(10L)));
        this.client.admin().indices().create(createIndexRequest, new ActionListener<CreateIndexResponse>(){

            @Override
            public void onResponse(CreateIndexResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject().field("ok", true).field("acknowledged", response.acknowledged()).endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestCreateIndexAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

