/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram.bounded;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.bounded.InternalBoundedFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class BoundedValueHistogramFacetCollector
extends AbstractFacetCollector {
    private final String keyIndexFieldName;
    private final String valueIndexFieldName;
    private final long interval;
    private final HistogramFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType keyFieldDataType;
    private NumericFieldData keyFieldData;
    private final FieldDataType valueFieldDataType;
    private final HistogramProc histoProc;

    public BoundedValueHistogramFacetCollector(String facetName, String keyFieldName, String valueFieldName, long interval, long from, long to, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.interval = interval;
        this.comparatorType = comparatorType;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(keyFieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + keyFieldName + "]");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.keyIndexFieldName = smartMappers.mapper().names().indexName();
        this.keyFieldDataType = smartMappers.mapper().fieldDataType();
        FieldMapper mapper = context.mapperService().smartNameFieldMapper(valueFieldName);
        if (mapper == null) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for value_field [" + valueFieldName + "]");
        }
        this.valueIndexFieldName = mapper.names().indexName();
        this.valueFieldDataType = mapper.fieldDataType();
        long normalizedFrom = (long)((double)from / (double)interval) * interval;
        long normalizedTo = (long)((double)to / (double)interval) * interval;
        if (to % interval != 0L) {
            normalizedTo += interval;
        }
        long offset = -normalizedFrom;
        int size = (int)((normalizedTo - normalizedFrom) / interval);
        this.histoProc = new HistogramProc(from, to, interval, offset, size);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.keyFieldData.forEachValueInDoc(doc, this.histoProc);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyFieldData = (NumericFieldData)this.fieldDataCache.cache(this.keyFieldDataType, reader, this.keyIndexFieldName);
        this.histoProc.valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.valueIndexFieldName);
    }

    @Override
    public Facet facet() {
        return new InternalBoundedFullHistogramFacet(this.facetName, this.comparatorType, this.interval, -this.histoProc.offset, this.histoProc.size, this.histoProc.entries, true);
    }

    public static class HistogramProc
    implements NumericFieldData.LongValueInDocProc {
        final long from;
        final long to;
        final long interval;
        final long offset;
        final int size;
        final Object[] entries;
        NumericFieldData valueFieldData;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public HistogramProc(long from, long to, long interval, long offset, int size) {
            this.from = from;
            this.to = to;
            this.interval = interval;
            this.offset = offset;
            this.size = size;
            this.entries = CacheRecycler.popObjectArray(size);
        }

        @Override
        public void onValue(int docId, long value) {
            if (value <= this.from || value > this.to) {
                return;
            }
            int index = (int)((value + this.offset) / this.interval);
            InternalBoundedFullHistogramFacet.FullEntry entry = (InternalBoundedFullHistogramFacet.FullEntry)this.entries[index];
            if (entry == null) {
                entry = new InternalBoundedFullHistogramFacet.FullEntry(index, 0L, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0L, 0.0);
                this.entries[index] = entry;
            }
            ++entry.count;
            this.valueAggregator.entry = entry;
            this.valueFieldData.forEachValueInDoc(docId, this.valueAggregator);
        }

        public static class ValueAggregator
        implements NumericFieldData.DoubleValueInDocProc {
            InternalBoundedFullHistogramFacet.FullEntry entry;

            @Override
            public void onValue(int docId, double value) {
                ++this.entry.totalCount;
                this.entry.total += value;
                if (value < this.entry.min) {
                    this.entry.min = value;
                }
                if (value > this.entry.max) {
                    this.entry.max = value;
                }
            }
        }
    }
}

