/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.TimeValue;

public class TrackingConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    private final ESLogger logger;
    private final AtomicLong totalMerges = new AtomicLong();
    private final AtomicLong totalMergeTime = new AtomicLong();
    private final AtomicLong currentMerges = new AtomicLong();

    public TrackingConcurrentMergeScheduler(ESLogger logger) {
        this.logger = logger;
    }

    public long totalMerges() {
        return this.totalMerges.get();
    }

    public long totalMergeTime() {
        return this.totalMergeTime.get();
    }

    public long currentMerges() {
        return this.currentMerges.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMerge(MergePolicy.OneMerge merge) throws IOException {
        long time = System.currentTimeMillis();
        this.currentMerges.incrementAndGet();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("merge [{}] starting...", merge.info.name);
        }
        try {
            super.doMerge(merge);
            this.currentMerges.decrementAndGet();
        }
        catch (Throwable throwable) {
            this.currentMerges.decrementAndGet();
            this.totalMerges.incrementAndGet();
            long took = System.currentTimeMillis() - time;
            this.totalMergeTime.addAndGet(took);
            if (took > 20000L) {
                this.logger.debug("merge [{}] done, took [{}]", merge.info.name, TimeValue.timeValueMillis(took));
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("merge [{}] done, took [{}]", merge.info.name, TimeValue.timeValueMillis(took));
            }
            throw throwable;
        }
        this.totalMerges.incrementAndGet();
        long took = System.currentTimeMillis() - time;
        this.totalMergeTime.addAndGet(took);
        if (took > 20000L) {
            this.logger.debug("merge [{}] done, took [{}]", merge.info.name, TimeValue.timeValueMillis(took));
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("merge [{}] done, took [{}]", merge.info.name, TimeValue.timeValueMillis(took));
        }
    }
}

