/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.elasticsearch.common.util.concurrent.NotThreadSafe;

@NotThreadSafe
public class FastCharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public FastCharArrayWriter() {
        this(32);
    }

    public FastCharArrayWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative initial size: " + initialSize);
        }
        this.buf = new char[initialSize];
    }

    @Override
    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public void write(String str, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    @Override
    public FastCharArrayWriter append(CharSequence csq) {
        String s = csq == null ? "null" : ((Object)csq).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public FastCharArrayWriter append(CharSequence csq, int start, int end) {
        String s = ((Object)(csq == null ? "null" : csq).subSequence(start, end)).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public FastCharArrayWriter append(char c) {
        this.write(c);
        return this;
    }

    public void reset() {
        this.count = 0;
    }

    public char[] toCharArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public char[] unsafeCharArray() {
        return this.buf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toStringTrim() {
        int len;
        int st = 0;
        char[] val = this.buf;
        for (len = this.count; st < len && val[st] <= ' '; ++st, --len) {
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        return new String(this.buf, st, len);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

