/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import org.elasticsearch.ElasticSearchIllegalArgumentException;

public enum VersionType {
    INTERNAL(0),
    EXTERNAL(1);

    private final byte value;

    private VersionType(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static VersionType fromString(String versionType) {
        if ("internal".equals(versionType)) {
            return INTERNAL;
        }
        if ("external".equals(versionType)) {
            return EXTERNAL;
        }
        throw new ElasticSearchIllegalArgumentException("No version type match [" + versionType + "]");
    }

    public static VersionType fromString(String versionType, VersionType defaultVersionType) {
        if (versionType == null) {
            return defaultVersionType;
        }
        if ("internal".equals(versionType)) {
            return INTERNAL;
        }
        if ("external".equals(versionType)) {
            return EXTERNAL;
        }
        throw new ElasticSearchIllegalArgumentException("No version type match [" + versionType + "]");
    }

    public static VersionType fromValue(byte value) {
        if (value == 0) {
            return INTERNAL;
        }
        if (value == 1) {
            return EXTERNAL;
        }
        throw new ElasticSearchIllegalArgumentException("No version type match [" + value + "]");
    }
}

