/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.support;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.concurrentlinkedhashmap.EvictionListener;
import org.elasticsearch.common.concurrentlinkedhashmap.Weigher;
import org.elasticsearch.common.lab.LongsLAB;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.search.NoCacheFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.filter.support.FilterCacheValue;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class AbstractWeightedFilterCache
extends AbstractIndexComponent
implements FilterCache,
IndexReader.ReaderFinishedListener,
EvictionListener<FilterCacheKey, FilterCacheValue<DocSet>> {
    final ConcurrentMap<Object, Boolean> seenReaders = ConcurrentCollections.newConcurrentMap();
    final boolean labEnabled;
    final ByteSizeValue labMaxAlloc;
    final ByteSizeValue labChunkSize;
    final int labMaxAllocBytes;
    final int labChunkSizeBytes;
    protected final AtomicLong evictions = new AtomicLong();

    protected AbstractWeightedFilterCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
        this.labEnabled = this.componentSettings.getAsBoolean("lab", false);
        this.labMaxAlloc = this.componentSettings.getAsBytesSize("lab.max_alloc", new ByteSizeValue(128L, ByteSizeUnit.KB));
        this.labChunkSize = this.componentSettings.getAsBytesSize("lab.chunk_size", new ByteSizeValue(1L, ByteSizeUnit.MB));
        this.labMaxAllocBytes = (int)(this.labMaxAlloc.bytes() / 8L);
        this.labChunkSizeBytes = (int)(this.labChunkSize.bytes() / 8L);
    }

    protected abstract ConcurrentMap<FilterCacheKey, FilterCacheValue<DocSet>> cache();

    @Override
    public void close() throws ElasticSearchException {
        this.clear();
    }

    @Override
    public void clear() {
        for (Object readerKey : this.seenReaders.keySet()) {
            Boolean removed = (Boolean)this.seenReaders.remove(readerKey);
            if (removed == null) {
                return;
            }
            ConcurrentMap<FilterCacheKey, FilterCacheValue<DocSet>> cache = this.cache();
            for (FilterCacheKey key : cache.keySet()) {
                if (key.readerKey() != readerKey) continue;
                cache.remove(key);
            }
        }
    }

    public void finished(IndexReader reader) {
        this.clear(reader);
    }

    @Override
    public void clear(IndexReader reader) {
        Boolean removed = (Boolean)this.seenReaders.remove(reader.getCoreCacheKey());
        if (removed == null) {
            return;
        }
        ConcurrentMap<FilterCacheKey, FilterCacheValue<DocSet>> cache = this.cache();
        for (FilterCacheKey key : cache.keySet()) {
            if (key.readerKey() != reader.getCoreCacheKey()) continue;
            cache.remove(key);
        }
    }

    @Override
    public FilterCache.EntriesStats entriesStats() {
        long sizeInBytes = 0L;
        long totalCount = 0L;
        HashSet<Object> segmentsCount = Sets.newHashSet();
        for (Map.Entry entry : this.cache().entrySet()) {
            if (!this.seenReaders.containsKey(((FilterCacheKey)entry.getKey()).readerKey())) continue;
            if (!segmentsCount.contains(((FilterCacheKey)entry.getKey()).readerKey())) {
                segmentsCount.add(((FilterCacheKey)entry.getKey()).readerKey());
            }
            sizeInBytes += ((DocSet)((Object)((FilterCacheValue)entry.getValue()).value())).sizeInBytes();
            ++totalCount;
        }
        return new FilterCache.EntriesStats(sizeInBytes, segmentsCount.size() == 0 ? 0L : totalCount / (long)segmentsCount.size());
    }

    @Override
    public long evictions() {
        return this.evictions.get();
    }

    @Override
    public Filter cache(Filter filterToCache) {
        if (filterToCache instanceof NoCacheFilter) {
            return filterToCache;
        }
        if (this.isCached(filterToCache)) {
            return filterToCache;
        }
        return new FilterCacheFilterWrapper(filterToCache, this);
    }

    @Override
    public boolean isCached(Filter filter) {
        return filter instanceof FilterCacheFilterWrapper;
    }

    @Override
    public void onEviction(FilterCacheKey filterCacheKey, FilterCacheValue<DocSet> docSetFilterCacheValue) {
        if (filterCacheKey != null && this.seenReaders.containsKey(filterCacheKey.readerKey())) {
            this.evictions.incrementAndGet();
        }
    }

    public static class FilterCacheKey {
        private final Object readerKey;
        private final Filter filter;

        public FilterCacheKey(Object readerKey, Filter filter) {
            this.readerKey = readerKey;
            this.filter = filter;
        }

        public Object readerKey() {
            return this.readerKey;
        }

        public Filter filter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            FilterCacheKey that = (FilterCacheKey)o;
            return this.readerKey == that.readerKey && this.filter.equals(that.filter);
        }

        public int hashCode() {
            return this.readerKey.hashCode() + 31 * this.filter().hashCode();
        }
    }

    public static class FilterCacheValueWeigher
    implements Weigher<FilterCacheValue<DocSet>> {
        public static final long FACTOR = 10L;

        @Override
        public int weightOf(FilterCacheValue<DocSet> value) {
            int weight = (int)Math.min(value.value().sizeInBytes() / 10L, Integer.MAX_VALUE);
            return weight == 0 ? 1 : weight;
        }
    }

    static class FilterCacheFilterWrapper
    extends Filter {
        private final Filter filter;
        private final AbstractWeightedFilterCache cache;

        FilterCacheFilterWrapper(Filter filter, AbstractWeightedFilterCache cache) {
            this.filter = filter;
            this.cache = cache;
        }

        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            FilterCacheKey cacheKey = new FilterCacheKey(reader.getCoreCacheKey(), this.filter);
            ConcurrentMap<FilterCacheKey, FilterCacheValue<DocSet>> innerCache = this.cache.cache();
            FilterCacheValue<DocSet> cacheValue = (FilterCacheValue<DocSet>)innerCache.get(cacheKey);
            if (cacheValue == null) {
                if (!this.cache.seenReaders.containsKey(reader.getCoreCacheKey())) {
                    reader.addReaderFinishedListener((IndexReader.ReaderFinishedListener)this.cache);
                    this.cache.seenReaders.put(reader.getCoreCacheKey(), Boolean.TRUE);
                }
                LongsLAB longsLAB = null;
                if (this.cache.labEnabled) {
                    longsLAB = new LongsLAB(this.cache.labChunkSizeBytes, this.cache.labMaxAllocBytes);
                }
                DocIdSet docIdSet = this.filter.getDocIdSet(reader);
                DocSet docSet = FilterCacheValue.cacheable(reader, longsLAB, docIdSet);
                cacheValue = new FilterCacheValue<DocSet>(docSet, longsLAB);
                innerCache.putIfAbsent(cacheKey, cacheValue);
            }
            return cacheValue.value() == DocSet.EMPTY_DOC_SET ? null : (DocSet)((Object)cacheValue.value());
        }

        public String toString() {
            return "FilterCacheFilterWrapper(" + this.filter + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof FilterCacheFilterWrapper)) {
                return false;
            }
            return this.filter.equals(((FilterCacheFilterWrapper)((Object)o)).filter);
        }

        public int hashCode() {
            return this.filter.hashCode() ^ 0x1117BF25;
        }
    }
}

