/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.xcontent.NumberFieldMapper;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentFilterParser;
import org.elasticsearch.index.settings.IndexSettings;

public class NumericRangeFilterParser
extends AbstractIndexComponent
implements XContentFilterParser {
    public static final String NAME = "numeric_range";

    @Inject
    public NumericRangeFilterParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "numericRange"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        String fieldName = null;
        String from = null;
        String to = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("from".equals(currentFieldName)) {
                        from = parser.textOrNull();
                        continue;
                    }
                    if ("to".equals(currentFieldName)) {
                        to = parser.textOrNull();
                        continue;
                    }
                    if ("include_lower".equals(currentFieldName) || "includeLower".equals(currentFieldName)) {
                        includeLower = parser.booleanValue();
                        continue;
                    }
                    if ("include_upper".equals(currentFieldName) || "includeUpper".equals(currentFieldName)) {
                        includeUpper = parser.booleanValue();
                        continue;
                    }
                    if ("gt".equals(currentFieldName)) {
                        from = parser.textOrNull();
                        includeLower = false;
                        continue;
                    }
                    if ("gte".equals(currentFieldName) || "ge".equals(currentFieldName)) {
                        from = parser.textOrNull();
                        includeLower = true;
                        continue;
                    }
                    if ("lt".equals(currentFieldName)) {
                        to = parser.textOrNull();
                        includeUpper = false;
                        continue;
                    }
                    if (!"lte".equals(currentFieldName) && !"le".equals(currentFieldName)) continue;
                    to = parser.textOrNull();
                    includeUpper = true;
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if (!"_cache".equals(currentFieldName)) continue;
            cache = parser.booleanValue();
        }
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers == null || !smartNameFieldMappers.hasMapper()) {
            throw new QueryParsingException(this.index, "failed to find mapping for field [" + fieldName + "]");
        }
        FieldMapper mapper = smartNameFieldMappers.mapper();
        if (!(mapper instanceof NumberFieldMapper)) {
            throw new QueryParsingException(this.index, "Field [" + fieldName + "] is not a numeric type");
        }
        Filter filter = ((NumberFieldMapper)mapper).rangeFilter(parseContext.indexCache().fieldData(), from, to, includeLower, includeUpper);
        if (cache) {
            filter = parseContext.cacheFilter(filter);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartNameFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

