/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsStats;

public class OsService
extends AbstractComponent {
    private final OsProbe probe;
    private final OsInfo info;
    private final TimeValue refreshInterval;
    private OsStats cachedStats;

    @Inject
    public OsService(Settings settings, OsProbe probe) {
        super(settings);
        this.probe = probe;
        this.refreshInterval = this.componentSettings.getAsTime("refresh_interval", TimeValue.timeValueSeconds(5L));
        this.info = probe.osInfo();
        this.info.refreshInterval = this.refreshInterval.millis();
        this.cachedStats = probe.osStats();
        this.logger.debug("Using probe [{}] with refresh_interval [{}]", probe, this.refreshInterval);
    }

    public OsInfo info() {
        return this.info;
    }

    public synchronized OsStats stats() {
        if (System.currentTimeMillis() - this.cachedStats.timestamp() > this.refreshInterval.millis()) {
            this.cachedStats = this.probe.osStats();
        }
        return this.cachedStats;
    }
}

