/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.cluster;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.river.cluster.PublishRiverClusterStateAction;
import org.elasticsearch.river.cluster.RiverClusterChangedEvent;
import org.elasticsearch.river.cluster.RiverClusterState;
import org.elasticsearch.river.cluster.RiverClusterStateListener;
import org.elasticsearch.river.cluster.RiverClusterStateUpdateTask;
import org.elasticsearch.transport.TransportService;

public class RiverClusterService
extends AbstractLifecycleComponent<RiverClusterService> {
    private final ClusterService clusterService;
    private final PublishRiverClusterStateAction publishAction;
    private final List<RiverClusterStateListener> clusterStateListeners = new CopyOnWriteArrayList<RiverClusterStateListener>();
    private volatile ExecutorService updateTasksExecutor;
    private volatile RiverClusterState clusterState = RiverClusterState.builder().build();

    @Inject
    public RiverClusterService(Settings settings, TransportService transportService, ClusterService clusterService) {
        super(settings);
        this.clusterService = clusterService;
        this.publishAction = new PublishRiverClusterStateAction(settings, transportService, clusterService, new UpdateClusterStateListener());
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.updateTasksExecutor = Executors.newSingleThreadExecutor(EsExecutors.daemonThreadFactory(this.settings, "riverClusterService#updateTask"));
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.updateTasksExecutor.shutdown();
        try {
            this.updateTasksExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    public void add(RiverClusterStateListener listener) {
        this.clusterStateListeners.add(listener);
    }

    public void remove(RiverClusterStateListener listener) {
        this.clusterStateListeners.remove(listener);
    }

    public void submitStateUpdateTask(final String source, final RiverClusterStateUpdateTask updateTask) {
        if (!this.lifecycle.started()) {
            return;
        }
        this.updateTasksExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!RiverClusterService.this.lifecycle.started()) {
                    RiverClusterService.this.logger.debug("processing [{}]: ignoring, cluster_service not started", source);
                    return;
                }
                RiverClusterService.this.logger.debug("processing [{}]: execute", source);
                RiverClusterState previousClusterState = RiverClusterService.this.clusterState;
                try {
                    RiverClusterService.this.clusterState = updateTask.execute(previousClusterState);
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder("failed to execute cluster state update, state:\nversion [").append(RiverClusterService.this.clusterState.version()).append("], source [").append(source).append("]\n");
                    RiverClusterService.this.logger.warn(sb.toString(), e, new Object[0]);
                    return;
                }
                if (previousClusterState != RiverClusterService.this.clusterState) {
                    if (RiverClusterService.this.clusterService.state().nodes().localNodeMaster()) {
                        RiverClusterService.this.clusterState = new RiverClusterState(RiverClusterService.this.clusterState.version() + 1L, RiverClusterService.this.clusterState);
                    } else if (RiverClusterService.this.clusterState.version() < previousClusterState.version()) {
                        RiverClusterService.this.logger.debug("got old cluster state [" + RiverClusterService.this.clusterState.version() + "<" + previousClusterState.version() + "] from source [" + source + "], ignoring", new Object[0]);
                        return;
                    }
                    if (RiverClusterService.this.logger.isTraceEnabled()) {
                        StringBuilder sb = new StringBuilder("cluster state updated:\nversion [").append(RiverClusterService.this.clusterState.version()).append("], source [").append(source).append("]\n");
                        RiverClusterService.this.logger.trace(sb.toString(), new Object[0]);
                    } else if (RiverClusterService.this.logger.isDebugEnabled()) {
                        RiverClusterService.this.logger.debug("cluster state updated, version [{}], source [{}]", RiverClusterService.this.clusterState.version(), source);
                    }
                    RiverClusterChangedEvent clusterChangedEvent = new RiverClusterChangedEvent(source, RiverClusterService.this.clusterState, previousClusterState);
                    for (RiverClusterStateListener listener : RiverClusterService.this.clusterStateListeners) {
                        listener.riverClusterChanged(clusterChangedEvent);
                    }
                    if (RiverClusterService.this.clusterService.state().nodes().localNodeMaster()) {
                        RiverClusterService.this.publishAction.publish(RiverClusterService.this.clusterState);
                    }
                    RiverClusterService.this.logger.debug("processing [{}]: done applying updated cluster_state", source);
                } else {
                    RiverClusterService.this.logger.debug("processing [{}]: no change in cluster_state", source);
                }
            }
        });
    }

    private class UpdateClusterStateListener
    implements PublishRiverClusterStateAction.NewClusterStateListener {
        private UpdateClusterStateListener() {
        }

        @Override
        public void onNewClusterState(final RiverClusterState clusterState) {
            ClusterState state = RiverClusterService.this.clusterService.state();
            if (state.nodes().localNodeMaster()) {
                RiverClusterService.this.logger.warn("master should not receive new cluster state from [{}]", state.nodes().masterNode());
                return;
            }
            RiverClusterService.this.submitStateUpdateTask("received_state", new RiverClusterStateUpdateTask(){

                @Override
                public RiverClusterState execute(RiverClusterState currentState) {
                    return clusterState;
                }
            });
        }
    }
}

