/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import org.apache.commons.lang.Validate;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.action.search.SearchRequestBuilder;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import play.Logger;
import play.db.Model;
import play.modules.elasticsearch.search.SearchResults;
import play.modules.elasticsearch.transformer.JPATransformer;
import play.modules.elasticsearch.transformer.Transformer;

public class Query<T extends Model> {
    private final Class<T> clazz;
    private final SearchRequestBuilder builder;
    private int from = -1;
    private int size = -1;
    private boolean hydrate = false;

    Query(Class<T> clazz, SearchRequestBuilder builder) {
        Validate.notNull(clazz, (String)"clazz cannot be null");
        Validate.notNull((Object)builder, (String)"builder cannot be null");
        this.clazz = clazz;
        this.builder = builder;
    }

    public Query from(int from) {
        this.from = from;
        return this;
    }

    public Query size(int size) {
        this.size = size;
        return this;
    }

    public Query hydrate(boolean hydrate) {
        this.hydrate = hydrate;
        return this;
    }

    public Query addFacet(AbstractFacetBuilder facet) {
        Validate.notNull((Object)facet, (String)"facet cannot be null");
        this.builder.addFacet(facet);
        return this;
    }

    public SearchResults<T> fetch() {
        if (this.from > -1) {
            this.builder.setFrom(this.from);
        }
        if (this.size > -1) {
            this.builder.setSize(this.size);
        }
        if (this.hydrate) {
            this.builder.addField("_id");
        }
        if (Logger.isDebugEnabled()) {
            Logger.debug((String)"ES Query: %s", (Object[])new Object[]{this.builder.toString()});
        }
        SearchResponse searchResponse = (SearchResponse)this.builder.execute().actionGet();
        SearchResults<T> searchResults = null;
        searchResults = this.hydrate ? JPATransformer.toSearchResults(searchResponse, this.clazz) : Transformer.toSearchResults(searchResponse, this.clazz);
        return searchResults;
    }
}

