/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.adapter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import play.Logger;
import play.db.Model;
import play.modules.elasticsearch.annotations.ElasticSearchEmbedded;
import play.modules.elasticsearch.annotations.ElasticSearchIgnore;
import play.modules.elasticsearch.util.ExceptionUtil;
import play.modules.elasticsearch.util.ReflectionUtil;

public abstract class ElasticSearchAdapter {
    private static List<String> IGNORE_FIELDS = new ArrayList<String>();

    public static void startIndex(Client client, Class<?> clazz) {
        ElasticSearchAdapter.createIndex(client, ElasticSearchAdapter.getIndexName(clazz));
    }

    public static void startIndex(Client client, String clazz) {
        ElasticSearchAdapter.createIndex(client, ElasticSearchAdapter.getIndexName(clazz));
    }

    private static void createIndex(Client client, String indexName) {
        try {
            Logger.debug((String)"Starting Elastic Search Index %s", (Object[])new Object[]{indexName});
            CreateIndexResponse response = (CreateIndexResponse)client.admin().indices().create(new CreateIndexRequest(indexName)).actionGet();
            Logger.debug((String)"Response: %s", (Object[])new Object[]{response});
        }
        catch (IndexAlreadyExistsException iaee) {
            Logger.debug((String)"Index already exists: %s", (Object[])new Object[]{indexName});
        }
        catch (Throwable t) {
            Logger.warn((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Model> void indexModel(Client client, T model) throws Exception {
        Logger.debug((String)"Index Model: %s", (Object[])new Object[]{model});
        if (client == null) {
            Logger.error((String)"Elastic Search Client is null, aborting", (Object[])new Object[0]);
            return;
        }
        XContentBuilder contentBuilder = null;
        try {
            String indexName = ElasticSearchAdapter.getIndexName(model);
            Logger.debug((String)"Index Name: %s", (Object[])new Object[]{indexName});
            contentBuilder = XContentFactory.jsonBuilder().startObject();
            ElasticSearchAdapter.addModelToDocument(model, ElasticSearchAdapter.getFieldsToIndex(model.getClass()), "", contentBuilder, 0);
            contentBuilder = contentBuilder.endObject().prettyPrint();
            IndexResponse response = (IndexResponse)client.prepareIndex(indexName, indexName, model._key().toString()).setSource(contentBuilder).execute().actionGet();
            Logger.info((String)"Index Response: %s", (Object[])new Object[]{response});
        }
        finally {
            if (contentBuilder != null) {
                contentBuilder.close();
            }
        }
    }

    private static List<Field> getFieldsToIndex(Class<?> clazz) {
        List<Field> indexableFields = ReflectionUtil.getAllFieldsWithoutAnnotation(clazz, ElasticSearchIgnore.class);
        ArrayList<Field> fieldsToIndex = new ArrayList<Field>();
        for (Field field : indexableFields) {
            String name = field.getName();
            if (!StringUtils.isNotBlank((String)name) || IGNORE_FIELDS.contains(name)) continue;
            fieldsToIndex.add(field);
        }
        return fieldsToIndex;
    }

    private static List<Field> getFieldsToIndex(Class<?> clazz, ElasticSearchEmbedded embedded) {
        if (embedded.fields().length == 0) {
            return ElasticSearchAdapter.getFieldsToIndex(clazz);
        }
        List<Field> indexableFields = ReflectionUtil.getAllFields(clazz);
        List<String> selectedFields = Arrays.asList(embedded.fields());
        ArrayList<Field> fieldsToIndex = new ArrayList<Field>();
        for (Field field : indexableFields) {
            String name = field.getName();
            if (!StringUtils.isNotBlank((String)name) || IGNORE_FIELDS.contains(name) || !selectedFields.contains(name)) continue;
            fieldsToIndex.add(field);
        }
        if (selectedFields.size() != fieldsToIndex.size()) {
            Logger.warn((String)"Not all fields specified in ElasticSearchEmbedded could be found (model: %s, fields: %s)", (Object[])new Object[]{clazz, selectedFields});
        }
        return fieldsToIndex;
    }

    private static void addModelToDocument(Object model, List<Field> fieldsToInclude, String prefix, XContentBuilder contentBuilder, int depth) throws Exception {
        if (depth > 2) {
            Logger.warn((String)"3-level recursion detected, ignoring further recursion", (Object[])new Object[0]);
            return;
        }
        for (Field field : fieldsToInclude) {
            String name = field.getName();
            Object value = ReflectionUtil.getFieldValue(model, name);
            if (value != null) {
                if (field.isAnnotationPresent(ElasticSearchEmbedded.class)) {
                    Logger.info((String)"Field: %s%s will be embedded", (Object[])new Object[]{prefix, name});
                    ElasticSearchEmbedded embedded = field.getAnnotation(ElasticSearchEmbedded.class);
                    List<Field> embeddedFields = ElasticSearchAdapter.getFieldsToIndex(value.getClass(), embedded);
                    String embeddedPrefix = prefix + name + ".";
                    ElasticSearchAdapter.addModelToDocument(value, embeddedFields, embeddedPrefix, contentBuilder, depth++);
                    continue;
                }
                Logger.debug((String)"Field: %s%s, Value: %s", (Object[])new Object[]{prefix, name, value});
                contentBuilder.field(prefix + name, value);
                continue;
            }
            Logger.debug((String)("No Value for Field: " + name), (Object[])new Object[0]);
        }
    }

    public static <T extends Model> void deleteModel(Client client, T model) throws Exception {
        Logger.debug((String)"Delete Model: %s", (Object[])new Object[]{model});
        DeleteResponse response = (DeleteResponse)client.prepareDelete(ElasticSearchAdapter.getIndexName(model), ElasticSearchAdapter.getIndexName(model), String.valueOf(model._key())).setOperationThreaded(false).execute().actionGet();
        Logger.debug((String)"Delete Response: %s", (Object[])new Object[]{response});
    }

    public static String getIndexName(Model model) {
        return ElasticSearchAdapter.getIndexName(model.getClass());
    }

    public static String getIndexName(Class clazz) {
        return ElasticSearchAdapter.getIndexName(clazz.getName());
    }

    private static String getIndexName(String clazz) {
        Logger.debug((String)"Class: %s", (Object[])new Object[]{clazz});
        String value = clazz.toLowerCase().trim().replace('.', '_');
        Logger.debug((String)"Index Name: %s", (Object[])new Object[]{value});
        return value;
    }

    static {
        IGNORE_FIELDS.add("avoidCascadeSaveLoops");
        IGNORE_FIELDS.add("willBeSaved");
        IGNORE_FIELDS.add("serialVersionId");
        IGNORE_FIELDS.add("serialVersionUID");
    }
}

