/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import play.Logger;
import play.libs.F;
import play.modules.elasticsearch.ElasticSearchIndexEvent;
import play.modules.elasticsearch.ElasticSearchPlugin;
import play.modules.elasticsearch.adapter.ElasticSearchAdapter;
import play.modules.elasticsearch.util.ExceptionUtil;

public class ElasticSearchIndexAction
implements F.Action<ElasticSearchIndexEvent> {
    public void invoke(ElasticSearchIndexEvent message) {
        Logger.info((String)"Elastic Search - %s Event", (Object[])new Object[]{message});
        try {
            switch (message.getType()) {
                case INDEX: {
                    ElasticSearchAdapter.indexModel(ElasticSearchPlugin.client(), message.getObject());
                    break;
                }
                case DELETE: {
                    ElasticSearchAdapter.deleteModel(ElasticSearchPlugin.client(), message.getObject());
                }
            }
        }
        catch (Throwable t) {
            Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
        }
    }
}

