/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.versioned;

import java.io.IOException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;
import org.elasticsearch.common.lucene.versioned.VersionedMap;
import org.elasticsearch.common.util.concurrent.ThreadSafe;

@ThreadSafe
public class VersionedIndexReader
extends FilterIndexReader {
    protected final int version;
    protected final VersionedMap versionedMap;

    public VersionedIndexReader(IndexReader in, int version, VersionedMap versionedMap) {
        super(in);
        this.version = version;
        this.versionedMap = versionedMap;
    }

    public TermDocs termDocs() throws IOException {
        return new VersionedTermDocs(this.in.termDocs());
    }

    public TermDocs termDocs(Term term) throws IOException {
        return new VersionedTermDocs(this.in.termDocs(term));
    }

    public TermPositions termPositions() throws IOException {
        return new VersionedTermPositions(this.in.termPositions());
    }

    public TermPositions termPositions(Term term) throws IOException {
        return new VersionedTermPositions(this.in.termPositions(term));
    }

    private class VersionedTermPositions
    extends VersionedTermDocs
    implements TermPositions {
        final TermPositions _tp;

        public VersionedTermPositions(TermPositions in) {
            super((TermDocs)in);
            this._tp = in;
        }

        public int nextPosition() throws IOException {
            return this._tp.nextPosition();
        }

        public int getPayloadLength() {
            return this._tp.getPayloadLength();
        }

        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return this._tp.getPayload(data, offset);
        }

        public boolean isPayloadAvailable() {
            return this._tp.isPayloadAvailable();
        }
    }

    private class VersionedTermDocs
    extends FilterIndexReader.FilterTermDocs {
        public VersionedTermDocs(TermDocs in) {
            super(in);
        }

        public boolean next() throws IOException {
            while (this.in.next()) {
                if (!VersionedIndexReader.this.versionedMap.beforeVersion(this.in.doc(), VersionedIndexReader.this.version)) continue;
                return true;
            }
            return false;
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int i = 0;
            while (i < docs.length) {
                if (!this.in.next()) {
                    return i;
                }
                int doc = this.in.doc();
                if (!VersionedIndexReader.this.versionedMap.beforeVersion(doc, VersionedIndexReader.this.version)) continue;
                docs[i] = doc;
                freqs[i] = this.in.freq();
                ++i;
            }
            return i;
        }

        public boolean skipTo(int i) throws IOException {
            if (!this.in.skipTo(i)) {
                return false;
            }
            if (VersionedIndexReader.this.versionedMap.beforeVersion(this.in.doc(), VersionedIndexReader.this.version)) {
                return true;
            }
            return this.next();
        }
    }
}

