/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.common.collect.SafeArray;
import org.elasticsearch.common.util.concurrent.ThreadSafe;

@ThreadSafe
public class ConcurrentSafeArray<T>
implements SafeArray<T> {
    private final ArrayList<T> list = new ArrayList();
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        this.rwl.readLock().lock();
        try {
            T t = this.list.get(index);
            return t;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.rwl.readLock().lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T value) {
        this.rwl.writeLock().lock();
        try {
            this.list.add(value);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T value) {
        this.rwl.writeLock().lock();
        try {
            this.list.add(index, value);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.rwl.writeLock().lock();
        try {
            this.list.clear();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forEach(SafeArray.Procedure<T> procedure) {
        this.rwl.readLock().lock();
        try {
            for (int i = 0; i < this.list.size(); ++i) {
                if (procedure.execute(this.list.get(i))) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }
}

