/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.netty.handler.codec.http.HttpMethod;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.support.AbstractRestRequest;
import org.elasticsearch.rest.support.RestUtils;

public class NettyHttpRequest
extends AbstractRestRequest
implements HttpRequest {
    private final org.elasticsearch.common.netty.handler.codec.http.HttpRequest request;
    private final Map<String, String> params;
    private final String rawPath;
    private byte[] cachedData;
    private static Charset UTF8 = Charset.forName("UTF-8");

    public NettyHttpRequest(org.elasticsearch.common.netty.handler.codec.http.HttpRequest request) {
        this.request = request;
        this.params = new HashMap<String, String>();
        String uri = request.getUri();
        int pathEndPos = uri.indexOf(63);
        if (pathEndPos < 0) {
            this.rawPath = uri;
        } else {
            this.rawPath = uri.substring(0, pathEndPos);
            RestUtils.decodeQueryString(uri, pathEndPos + 1, this.params);
        }
    }

    @Override
    public RestRequest.Method method() {
        HttpMethod httpMethod = this.request.getMethod();
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        return RestRequest.Method.GET;
    }

    @Override
    public String uri() {
        return this.request.getUri();
    }

    @Override
    public String rawPath() {
        return this.rawPath;
    }

    @Override
    public Map<String, String> params() {
        return this.params;
    }

    @Override
    public boolean hasContent() {
        return this.request.getContent().readableBytes() > 0;
    }

    @Override
    public int contentLength() {
        return this.request.getContent().readableBytes();
    }

    @Override
    public boolean contentUnsafe() {
        return this.request.getContent().hasArray();
    }

    @Override
    public byte[] contentByteArray() {
        if (this.request.getContent().hasArray()) {
            return this.request.getContent().array();
        }
        if (this.cachedData != null) {
            return this.cachedData;
        }
        this.cachedData = new byte[this.request.getContent().readableBytes()];
        this.request.getContent().getBytes(this.request.getContent().readerIndex(), this.cachedData);
        return this.cachedData;
    }

    @Override
    public int contentByteArrayOffset() {
        if (this.request.getContent().hasArray()) {
            return this.request.getContent().arrayOffset() + this.request.getContent().readerIndex();
        }
        return 0;
    }

    @Override
    public String contentAsString() {
        return this.request.getContent().toString(UTF8);
    }

    @Override
    public String header(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    @Override
    public String param(String key) {
        return this.params.get(key);
    }

    @Override
    public String param(String key, String defaultValue) {
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

