/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.all.AllField;
import org.elasticsearch.common.lucene.all.AllTermQuery;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.query.xcontent.QueryParseContext;

public class AllFieldMapper
extends AbstractFieldMapper<Void>
implements org.elasticsearch.index.mapper.AllFieldMapper {
    public static final String CONTENT_TYPE = "_all";
    private boolean enabled;

    public AllFieldMapper() {
        this(CONTENT_TYPE, Defaults.STORE, Defaults.TERM_VECTOR, false, false, null, null, true);
    }

    protected AllFieldMapper(String name, Field.Store store, Field.TermVector termVector, boolean omitNorms, boolean omitTermFreqAndPositions, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, boolean enabled) {
        super(new FieldMapper.Names(name, name, name, name), Field.Index.ANALYZED, store, termVector, 1.0f, omitNorms, omitTermFreqAndPositions, indexAnalyzer, searchAnalyzer);
        this.enabled = enabled;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public Query queryStringTermQuery(Term term) {
        return new AllTermQuery(term);
    }

    @Override
    public Query fieldQuery(String value, QueryParseContext context) {
        return new AllTermQuery(this.termFactory.createTerm(value));
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        if (!this.enabled) {
            return null;
        }
        context.allEntries().reset();
        Analyzer analyzer = this.findAnalyzer(context);
        return new AllField(this.names.indexName(), this.store, this.termVector, context.allEntries(), analyzer);
    }

    private Analyzer findAnalyzer(ParseContext context) {
        NamedAnalyzer analyzer = this.indexAnalyzer;
        if (analyzer == null && (analyzer = context.analyzer()) == null) {
            analyzer = Lucene.STANDARD_ANALYZER;
        }
        return analyzer;
    }

    @Override
    public Void value(Fieldable field) {
        return null;
    }

    @Override
    public Void valueFromString(String value) {
        return null;
    }

    @Override
    public String valueAsString(Fieldable field) {
        return null;
    }

    @Override
    public Object valueForSearch(Fieldable field) {
        return null;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.enabled && this.store == Defaults.STORE && this.termVector == Defaults.TERM_VECTOR && this.indexAnalyzer == null && this.searchAnalyzer == null) {
            return builder;
        }
        builder.startObject(CONTENT_TYPE);
        if (!this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (this.indexAnalyzer != null && this.searchAnalyzer != null && this.indexAnalyzer.name().equals(this.searchAnalyzer.name()) && !this.indexAnalyzer.name().startsWith("_")) {
            builder.field("analyzer", this.indexAnalyzer.name());
        } else {
            if (this.indexAnalyzer != null && !this.indexAnalyzer.name().startsWith("_")) {
                builder.field("index_analyzer", this.indexAnalyzer.name());
            }
            if (this.searchAnalyzer != null && !this.searchAnalyzer.name().startsWith("_")) {
                builder.field("search_analyzer", this.searchAnalyzer.name());
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, AllFieldMapper> {
        private boolean enabled = true;

        public Builder() {
            super(AllFieldMapper.CONTENT_TYPE);
            this.builder = this;
            this.indexName = AllFieldMapper.CONTENT_TYPE;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder store(Field.Store store) {
            return (Builder)super.store(store);
        }

        @Override
        public Builder termVector(Field.TermVector termVector) {
            return (Builder)super.termVector(termVector);
        }

        @Override
        protected Builder indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            return (Builder)super.indexAnalyzer(indexAnalyzer);
        }

        @Override
        protected Builder searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            return (Builder)super.searchAnalyzer(searchAnalyzer);
        }

        @Override
        public AllFieldMapper build(XContentMapper.BuilderContext context) {
            return new AllFieldMapper(this.name, this.store, this.termVector, this.omitNorms, this.omitTermFreqAndPositions, this.indexAnalyzer, this.searchAnalyzer, this.enabled);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_all";
        public static final String INDEX_NAME = "_all";
        public static final boolean ENABLED = true;
    }
}

