/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent.ip;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericAnalyzer;
import org.elasticsearch.index.analysis.NumericTokenizer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.LongFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.NumberFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapperBuilders;
import org.elasticsearch.index.mapper.xcontent.XContentTypeParsers;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class IpFieldMapper
extends NumberFieldMapper<Long> {
    public static final String CONTENT_TYPE = "ip";
    private static final Pattern pattern = Pattern.compile("\\.");
    private String nullValue;

    public static String longToIp(long longIp) {
        int octet3 = (int)((longIp >> 24) % 256L);
        int octet2 = (int)((longIp >> 16) % 256L);
        int octet1 = (int)((longIp >> 8) % 256L);
        int octet0 = (int)(longIp % 256L);
        return octet3 + "." + octet2 + "." + octet1 + "." + octet0;
    }

    public static long ipToLong(String ip) throws ElasticSearchIllegalArgumentException {
        try {
            String[] octets = pattern.split(ip);
            if (octets.length != 4) {
                throw new ElasticSearchIllegalArgumentException("failed ot parse ip [" + ip + "], not full ip address (4 dots)");
            }
            return (Long.parseLong(octets[0]) << 24) + (long)(Integer.parseInt(octets[1]) << 16) + (long)(Integer.parseInt(octets[2]) << 8) + (long)Integer.parseInt(octets[3]);
        }
        catch (Exception e) {
            if (e instanceof ElasticSearchIllegalArgumentException) {
                throw (ElasticSearchIllegalArgumentException)e;
            }
            throw new ElasticSearchIllegalArgumentException("failed to parse ip [" + ip + "]", e);
        }
    }

    protected IpFieldMapper(FieldMapper.Names names, int precisionStep, Field.Index index, Field.Store store, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, String nullValue) {
        super(names, precisionStep, null, index, store, boost, omitNorms, omitTermFreqAndPositions, new NamedAnalyzer("_ip/" + precisionStep, new NumericIpAnalyzer(precisionStep)), new NamedAnalyzer("_ip/max", new NumericIpAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
    }

    @Override
    protected int maxPrecisionStep() {
        return 64;
    }

    @Override
    public Long value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return null;
        }
        return Numbers.bytesToLong(value);
    }

    @Override
    public Long valueFromString(String value) {
        return IpFieldMapper.ipToLong(value);
    }

    @Override
    public Object valueForSearch(Fieldable field) {
        return this.valueAsString(field);
    }

    @Override
    public String valueAsString(Fieldable field) {
        Long value = this.value(field);
        if (value == null) {
            return null;
        }
        return IpFieldMapper.longToIp(value);
    }

    @Override
    public String indexedValue(String value) {
        return NumericUtils.longToPrefixCoded((long)IpFieldMapper.ipToLong(value));
    }

    @Override
    public Query fuzzyQuery(String value, String minSim, int prefixLength, int maxExpansions) {
        long iValue = IpFieldMapper.ipToLong(value);
        long iSim = IpFieldMapper.ipToLong(minSim);
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(iValue - iSim), (Long)(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query fuzzyQuery(String value, double minSim, int prefixLength, int maxExpansions) {
        return new FuzzyQuery(this.termFactory.createTerm(value), (float)minSim, prefixLength, maxExpansions);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(lowerTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(lowerTerm))), (Long)(upperTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(lowerTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(lowerTerm))), (Long)(upperTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFieldDataFilter.newLongRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(lowerTerm)), upperTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(upperTerm)), includeLower, includeUpper);
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        String ipAsString;
        if (context.externalValueSet()) {
            ipAsString = (String)context.externalValue();
            if (ipAsString == null) {
                ipAsString = this.nullValue;
            }
        } else {
            ipAsString = context.parser().currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : context.parser().text();
        }
        if (ipAsString == null) {
            return null;
        }
        if (context.includeInAll(this.includeInAll)) {
            context.allEntries().addText(this.names.fullName(), ipAsString, this.boost);
        }
        long value = IpFieldMapper.ipToLong(ipAsString);
        return new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, value);
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.LONG;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((IpFieldMapper)mergeWith).nullValue;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (!this.omitTermFreqAndPositions) {
            builder.field("omit_term_freq_and_positions", this.omitTermFreqAndPositions);
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
    }

    public static class NumericIpTokenizer
    extends NumericTokenizer {
        public NumericIpTokenizer(Reader reader, int precisionStep) throws IOException {
            super(reader, new NumericTokenStream(precisionStep), null);
        }

        public NumericIpTokenizer(Reader reader, int precisionStep, char[] buffer) throws IOException {
            super(reader, new NumericTokenStream(precisionStep), buffer, null);
        }

        @Override
        protected void setValue(NumericTokenStream tokenStream, String value) {
            tokenStream.setLongValue(IpFieldMapper.ipToLong(value));
        }
    }

    public static class NumericIpAnalyzer
    extends NumericAnalyzer<NumericIpTokenizer> {
        private final int precisionStep;

        public NumericIpAnalyzer() {
            this(4);
        }

        public NumericIpAnalyzer(int precisionStep) {
            this.precisionStep = precisionStep;
        }

        @Override
        protected NumericIpTokenizer createNumericTokenizer(Reader reader, char[] buffer) throws IOException {
            return new NumericIpTokenizer(reader, this.precisionStep, buffer);
        }
    }

    public static class TypeParser
    implements XContentMapper.TypeParser {
        @Override
        public XContentMapper.Builder parse(String name, Map<String, Object> node, XContentMapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = XContentMapperBuilders.ipField(name);
            XContentTypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(propNode.toString());
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, IpFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public IpFieldMapper build(XContentMapper.BuilderContext context) {
            IpFieldMapper fieldMapper = new IpFieldMapper(this.buildNames(context), this.precisionStep, this.index, this.store, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.nullValue);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final String NULL_VALUE = null;
    }
}

