/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.store;

import java.io.File;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndicesService;

public class IndicesStore
extends AbstractComponent
implements ClusterStateListener {
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesService;
    private final ClusterService clusterService;

    @Inject
    public IndicesStore(Settings settings, NodeEnvironment nodeEnv, IndicesService indicesService, ClusterService clusterService) {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        clusterService.add(this);
    }

    public void close() {
        this.clusterService.remove(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        File[] files;
        if (!event.routingTableChanged()) {
            return;
        }
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        RoutingTable routingTable = event.state().routingTable();
        for (IndexRoutingTable indexRoutingTable : routingTable) {
            IndexService indexService = this.indicesService.indexService(indexRoutingTable.index());
            if (indexService == null || !indexService.store().persistent()) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                if (indexService.hasShard(indexShardRoutingTable.shardId().id()) || !indexService.store().canDeleteUnallocated(indexShardRoutingTable.shardId()) || indexShardRoutingTable.countWithState(ShardRoutingState.STARTED) != indexShardRoutingTable.size()) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}] deleting unallocated shard", indexShardRoutingTable.shardId().index().name(), indexShardRoutingTable.shardId().id());
                }
                try {
                    indexService.store().deleteUnallocated(indexShardRoutingTable.shardId());
                }
                catch (Exception e) {
                    this.logger.debug("[{}][{}] failed to delete unallocated shard, ignoring", e, indexShardRoutingTable.shardId().index().name(), indexShardRoutingTable.shardId().id());
                }
            }
        }
        if (this.nodeEnv.hasNodeFile() && (files = this.nodeEnv.indicesLocation().listFiles()) != null) {
            for (File file : files) {
                if (event.state().metaData().hasIndex(file.getName())) continue;
                this.logger.debug("[{}] deleting index that is no longer in the cluster meta_date", file.getName());
                FileSystemUtils.deleteRecursively(file);
            }
        }
    }
}

