/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.count;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestCountAction
extends BaseRestHandler {
    @Inject
    public RestCountAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/_count", this);
        controller.registerHandler(RestRequest.Method.GET, "/_count", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_count", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_count", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_count", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_count", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        CountRequest countRequest = new CountRequest(RestActions.splitIndices(request.param("index")));
        countRequest.listenerThreaded(false);
        try {
            BroadcastOperationThreading operationThreading = BroadcastOperationThreading.fromString(request.param("operation_threading"), BroadcastOperationThreading.SINGLE_THREAD);
            if (operationThreading == BroadcastOperationThreading.NO_THREADS) {
                operationThreading = BroadcastOperationThreading.SINGLE_THREAD;
            }
            countRequest.operationThreading(operationThreading);
            if (request.hasContent()) {
                countRequest.query(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength(), true);
            } else {
                String source = request.param("source");
                if (source != null) {
                    countRequest.query(source);
                } else {
                    countRequest.query(RestActions.parseQuerySource(request));
                }
            }
            countRequest.queryParserName(request.param("query_parser_name"));
            countRequest.queryHint(request.param("query_hint"));
            countRequest.routing(request.param("routing"));
            countRequest.minScore(request.paramAsFloat("min_score", -1.0f));
            countRequest.types(RestActions.splitTypes(request.param("type")));
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.count(countRequest, new ActionListener<CountResponse>(){

            @Override
            public void onResponse(CountResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("count", response.count());
                    RestActions.buildBroadcastShardsHeader(builder, response);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestCountAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

