/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.longs.LongFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.datehistogram.CountDateHistogramFacetCollector;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalFullDateHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ValueScriptDateHistogramFacetCollector
extends AbstractFacetCollector {
    private final String indexFieldName;
    private final MutableDateTime dateTime;
    private final DateHistogramFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType fieldDataType;
    private LongFieldData fieldData;
    private final SearchScript valueScript;
    private final DateHistogramProc histoProc;

    public ValueScriptDateHistogramFacetCollector(String facetName, String fieldName, String scriptLang, String valueScript, Map<String, Object> params, MutableDateTime dateTime, long interval, DateHistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.dateTime = dateTime;
        this.comparatorType = comparatorType;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldName + "]");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.valueScript = context.scriptService().search(context.lookup(), scriptLang, valueScript, params);
        FieldMapper mapper = smartMappers.mapper();
        this.indexFieldName = mapper.names().indexName();
        this.fieldDataType = mapper.fieldDataType();
        this.histoProc = interval == 1L ? new DateHistogramProc(this.valueScript) : new IntervalDateHistogramProc(interval, this.valueScript);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.dateTime, this.histoProc);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.valueScript.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (LongFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
        this.valueScript.setNextReader(reader);
    }

    @Override
    public Facet facet() {
        return new InternalFullDateHistogramFacet(this.facetName, this.comparatorType, this.histoProc.entries, true);
    }

    public static class IntervalDateHistogramProc
    extends DateHistogramProc {
        private final long interval;

        public IntervalDateHistogramProc(long interval, SearchScript valueScript) {
            super(valueScript);
            this.interval = interval;
        }

        @Override
        public void onValue(int docId, MutableDateTime dateTime) {
            this.valueScript.setNextDocId(docId);
            long time = CountDateHistogramFacetCollector.bucket(dateTime.getMillis(), this.interval);
            double scriptValue = this.valueScript.runAsDouble();
            InternalFullDateHistogramFacet.FullEntry entry = (InternalFullDateHistogramFacet.FullEntry)this.entries.get(time);
            if (entry == null) {
                entry = new InternalFullDateHistogramFacet.FullEntry(time, 1L, scriptValue, scriptValue, 1L, scriptValue);
                this.entries.put(time, entry);
            } else {
                ++entry.count;
                ++entry.totalCount;
                entry.total += scriptValue;
                if (scriptValue < entry.min) {
                    entry.min = scriptValue;
                }
                if (scriptValue > entry.max) {
                    entry.max = scriptValue;
                }
            }
        }
    }

    public static class DateHistogramProc
    implements LongFieldData.DateValueInDocProc {
        protected final SearchScript valueScript;
        final ExtTLongObjectHashMap<InternalFullDateHistogramFacet.FullEntry> entries = CacheRecycler.popLongObjectMap();

        public DateHistogramProc(SearchScript valueScript) {
            this.valueScript = valueScript;
        }

        @Override
        public void onValue(int docId, MutableDateTime dateTime) {
            this.valueScript.setNextDocId(docId);
            long time = dateTime.getMillis();
            double scriptValue = this.valueScript.runAsDouble();
            InternalFullDateHistogramFacet.FullEntry entry = (InternalFullDateHistogramFacet.FullEntry)this.entries.get(time);
            if (entry == null) {
                entry = new InternalFullDateHistogramFacet.FullEntry(time, 1L, scriptValue, scriptValue, 1L, scriptValue);
                this.entries.put(time, entry);
            } else {
                ++entry.count;
                ++entry.totalCount;
                entry.total += scriptValue;
                if (scriptValue < entry.min) {
                    entry.min = scriptValue;
                }
                if (scriptValue > entry.max) {
                    entry.max = scriptValue;
                }
            }
        }
    }
}

