/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.ping.broadcast;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.ping.broadcast.BroadcastPingRequest;
import org.elasticsearch.action.admin.cluster.ping.broadcast.BroadcastPingResponse;
import org.elasticsearch.action.admin.cluster.ping.broadcast.BroadcastShardPingRequest;
import org.elasticsearch.action.admin.cluster.ping.broadcast.BroadcastShardPingResponse;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportBroadcastPingAction
extends TransportBroadcastOperationAction<BroadcastPingRequest, BroadcastPingResponse, BroadcastShardPingRequest, BroadcastShardPingResponse> {
    @Inject
    public TransportBroadcastPingAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, threadPool, clusterService, transportService);
    }

    @Override
    protected String executor() {
        return "cached";
    }

    @Override
    protected String transportAction() {
        return "/cluster/ping/broadcast";
    }

    @Override
    protected String transportShardAction() {
        return "/cluster/ping/broadcast/shard";
    }

    @Override
    protected BroadcastPingRequest newRequest() {
        return new BroadcastPingRequest();
    }

    @Override
    protected GroupShardsIterator shards(BroadcastPingRequest request, ClusterState clusterState) {
        return this.clusterService.operationRouting().searchShards(clusterState, request.indices(), request.queryHint(), null, null);
    }

    @Override
    protected BroadcastPingResponse newResponse(BroadcastPingRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) {
                ++failedShards;
                continue;
            }
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = Lists.newArrayList();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            ++successfulShards;
        }
        return new BroadcastPingResponse(shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    @Override
    protected BroadcastShardPingRequest newShardRequest() {
        return new BroadcastShardPingRequest();
    }

    @Override
    protected BroadcastShardPingRequest newShardRequest(ShardRouting shard, BroadcastPingRequest request) {
        return new BroadcastShardPingRequest(shard.index(), shard.id());
    }

    @Override
    protected BroadcastShardPingResponse newShardResponse() {
        return new BroadcastShardPingResponse();
    }

    @Override
    protected BroadcastShardPingResponse shardOperation(BroadcastShardPingRequest broadcastShardPingRequest) throws ElasticSearchException {
        return new BroadcastShardPingResponse();
    }
}

