/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class ShardReplicationOperationRequest
implements ActionRequest {
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(1L, TimeUnit.MINUTES);
    protected TimeValue timeout = DEFAULT_TIMEOUT;
    protected String index;
    private boolean threadedListener = false;
    private boolean threadedOperation = true;
    private ReplicationType replicationType = ReplicationType.DEFAULT;
    private WriteConsistencyLevel consistencyLevel = WriteConsistencyLevel.DEFAULT;

    public TimeValue timeout() {
        return this.timeout;
    }

    public String index() {
        return this.index;
    }

    public ShardReplicationOperationRequest index(String index) {
        this.index = index;
        return this;
    }

    @Override
    public boolean listenerThreaded() {
        return this.threadedListener;
    }

    @Override
    public ShardReplicationOperationRequest listenerThreaded(boolean threadedListener) {
        this.threadedListener = threadedListener;
        return this;
    }

    public boolean operationThreaded() {
        return this.threadedOperation;
    }

    public ShardReplicationOperationRequest operationThreaded(boolean threadedOperation) {
        this.threadedOperation = threadedOperation;
        return this;
    }

    public ReplicationType replicationType() {
        return this.replicationType;
    }

    public ShardReplicationOperationRequest replicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public ShardReplicationOperationRequest consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = Actions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.replicationType = ReplicationType.fromId(in.readByte());
        this.consistencyLevel = WriteConsistencyLevel.fromId(in.readByte());
        this.timeout = TimeValue.readTimeValue(in);
        this.index = in.readUTF();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.replicationType.id());
        out.writeByte(this.consistencyLevel.id());
        this.timeout.writeTo(out);
        out.writeUTF(this.index);
    }

    public void beforeLocalFork() {
    }
}

