/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.action.admin.cluster.support;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.support.PlainListenableActionFuture;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.action.RequestBuilder;
import org.elasticsearch.client.internal.InternalClusterAdminClient;

public abstract class BaseClusterRequestBuilder<Request extends ActionRequest, Response extends ActionResponse>
implements RequestBuilder<Request, Response> {
    protected final InternalClusterAdminClient client;
    protected final Request request;

    protected BaseClusterRequestBuilder(ClusterAdminClient client, Request request) {
        this.client = (InternalClusterAdminClient)client;
        this.request = request;
    }

    @Override
    public ListenableActionFuture<Response> execute() {
        PlainListenableActionFuture future = new PlainListenableActionFuture(this.request.listenerThreaded(), this.client.threadPool());
        this.execute(future);
        return future;
    }

    @Override
    public void execute(ActionListener<Response> listener) {
        this.doExecute(listener);
    }

    protected abstract void doExecute(ActionListener<Response> var1);
}

