/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.Immutable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;

@Immutable
public class MetaData
implements Iterable<IndexMetaData> {
    public static final MetaData EMPTY_META_DATA = MetaData.newMetaDataBuilder().build();
    private final ImmutableMap<String, IndexMetaData> indices;
    private final ImmutableMap<String, IndexTemplateMetaData> templates;
    private final transient int totalNumberOfShards;
    private final String[] allIndices;
    private final ImmutableSet<String> aliases;
    private final ImmutableMap<String, String[]> aliasAndIndexToIndexMap;

    private MetaData(ImmutableMap<String, IndexMetaData> indices, ImmutableMap<String, IndexTemplateMetaData> templates) {
        this.indices = ImmutableMap.copyOf(indices);
        this.templates = templates;
        int totalNumberOfShards = 0;
        for (IndexMetaData indexMetaData : indices.values()) {
            totalNumberOfShards += indexMetaData.totalNumberOfShards();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        ArrayList<String> allIndicesLst = Lists.newArrayList();
        for (IndexMetaData indexMetaData : indices.values()) {
            allIndicesLst.add(indexMetaData.index());
        }
        this.allIndices = allIndicesLst.toArray(new String[allIndicesLst.size()]);
        HashSet<String> aliases = Sets.newHashSet();
        for (IndexMetaData indexMetaData : indices.values()) {
            aliases.addAll(indexMetaData.aliases());
        }
        this.aliases = ImmutableSet.copyOf(aliases);
        MapBuilder tmpAliasAndIndexToIndexBuilder = MapBuilder.newMapBuilder();
        for (IndexMetaData indexMetaData : indices.values()) {
            Set<String> lst = (HashSet<String>)tmpAliasAndIndexToIndexBuilder.get(indexMetaData.index());
            if (lst == null) {
                lst = Sets.newHashSet();
                tmpAliasAndIndexToIndexBuilder.put(indexMetaData.index(), lst);
            }
            lst.add(indexMetaData.index());
            for (String alias : indexMetaData.aliases()) {
                lst = (Set)tmpAliasAndIndexToIndexBuilder.get(alias);
                if (lst == null) {
                    lst = Sets.newHashSet();
                    tmpAliasAndIndexToIndexBuilder.put(alias, lst);
                }
                lst.add(indexMetaData.index());
            }
        }
        MapBuilder aliasAndIndexToIndexBuilder = MapBuilder.newMapBuilder();
        for (Map.Entry entry : tmpAliasAndIndexToIndexBuilder.map().entrySet()) {
            aliasAndIndexToIndexBuilder.put(entry.getKey(), ((Set)entry.getValue()).toArray(new String[((Set)entry.getValue()).size()]));
        }
        this.aliasAndIndexToIndexMap = aliasAndIndexToIndexBuilder.immutableMap();
    }

    public ImmutableSet<String> aliases() {
        return this.aliases;
    }

    public ImmutableSet<String> getAliases() {
        return this.aliases();
    }

    public String[] concreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteAllIndices() {
        return this.concreteAllIndices();
    }

    public String[] concreteIndices(String[] indices) throws IndexMissingException {
        return this.concreteIndices(indices, false);
    }

    public String[] concreteIndicesIgnoreMissing(String[] indices) {
        return this.concreteIndices(indices, true);
    }

    public String[] concreteIndices(String[] indices, boolean ignoreMissing) throws IndexMissingException {
        if (indices == null || indices.length == 0) {
            return this.concreteAllIndices();
        }
        if (indices.length == 1) {
            String index = indices[0];
            if (index.length() == 0) {
                return this.concreteAllIndices();
            }
            if (index.equals("_all")) {
                return this.concreteAllIndices();
            }
            if (this.indices.containsKey(index)) {
                return indices;
            }
            String[] actualLst = this.aliasAndIndexToIndexMap.get(index);
            if (actualLst == null) {
                if (!ignoreMissing) {
                    throw new IndexMissingException(new Index(index));
                }
                return Strings.EMPTY_ARRAY;
            }
            return actualLst;
        }
        boolean possiblyAliased = false;
        for (String index : indices) {
            if (this.indices.containsKey(index)) continue;
            possiblyAliased = true;
            break;
        }
        if (!possiblyAliased) {
            return indices;
        }
        HashSet<String> actualIndices = Sets.newHashSetWithExpectedSize(indices.length);
        for (String index : indices) {
            String[] actualLst = this.aliasAndIndexToIndexMap.get(index);
            if (actualLst == null) {
                if (ignoreMissing) continue;
                throw new IndexMissingException(new Index(index));
            }
            for (String x : actualLst) {
                actualIndices.add(x);
            }
        }
        return actualIndices.toArray(new String[actualIndices.size()]);
    }

    public String concreteIndex(String index) throws IndexMissingException, ElasticSearchIllegalArgumentException {
        if (this.indices.containsKey(index)) {
            return index;
        }
        Object[] lst = this.aliasAndIndexToIndexMap.get(index);
        if (lst == null) {
            throw new IndexMissingException(new Index(index));
        }
        if (lst.length > 1) {
            throw new ElasticSearchIllegalArgumentException("Alias [" + index + "] has more than one indices associated with it [" + Arrays.toString(lst) + "], can't execute a single index op");
        }
        return lst[0];
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasConcreteIndex(String index) {
        return this.aliasAndIndexToIndexMap.containsKey(index);
    }

    public IndexMetaData index(String index) {
        return this.indices.get(index);
    }

    public ImmutableMap<String, IndexMetaData> indices() {
        return this.indices;
    }

    public ImmutableMap<String, IndexMetaData> getIndices() {
        return this.indices();
    }

    public ImmutableMap<String, IndexTemplateMetaData> templates() {
        return this.templates;
    }

    public ImmutableMap<String, IndexTemplateMetaData> getTemplates() {
        return this.templates;
    }

    public int totalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards();
    }

    @Override
    public UnmodifiableIterator<IndexMetaData> iterator() {
        return ((ImmutableCollection)this.indices.values()).iterator();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder newMetaDataBuilder() {
        return new Builder();
    }

    public static class Builder {
        private MapBuilder<String, IndexMetaData> indices = MapBuilder.newMapBuilder();
        private MapBuilder<String, IndexTemplateMetaData> templates = MapBuilder.newMapBuilder();

        public Builder metaData(MetaData metaData) {
            this.indices.putAll(metaData.indices);
            this.templates.putAll(metaData.templates);
            return this;
        }

        public Builder put(IndexMetaData.Builder indexMetaDataBuilder) {
            return this.put(indexMetaDataBuilder.build());
        }

        public Builder put(IndexMetaData indexMetaData) {
            this.indices.put(indexMetaData.index(), indexMetaData);
            return this;
        }

        public IndexMetaData get(String index) {
            return this.indices.get(index);
        }

        public Builder remove(String index) {
            this.indices.remove(index);
            return this;
        }

        public Builder put(IndexTemplateMetaData.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetaData template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder remoteTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indices.map().keySet().toArray(new String[this.indices.map().keySet().size()]);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexMissingException(new Index(index));
                }
                this.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).settings(ImmutableSettings.settingsBuilder().put(indexMetaData.settings()).put(settings)).build());
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indices.map().keySet().toArray(new String[this.indices.map().keySet().size()]);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexMissingException(new Index(index));
                }
                this.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).numberOfReplicas(numberOfReplicas).build());
            }
            return this;
        }

        public MetaData build() {
            return new MetaData(this.indices.immutableMap(), this.templates.immutableMap());
        }

        public static String toXContent(MetaData metaData) throws IOException {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            Builder.toXContent(metaData, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }

        public static void toXContent(MetaData metaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("meta-data");
            builder.startObject("templates");
            for (IndexTemplateMetaData template : metaData.templates().values()) {
                IndexTemplateMetaData.Builder.toXContent(template, builder, params);
            }
            builder.endObject();
            builder.startObject("indices");
            for (IndexMetaData indexMetaData : metaData) {
                IndexMetaData.Builder.toXContent(indexMetaData, builder, params);
            }
            builder.endObject();
            builder.endObject();
        }

        public static MetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                currentFieldName = parser.currentName();
                if (token == null) {
                    return builder.build();
                }
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if ("indices".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        builder.put(IndexMetaData.Builder.fromXContent(parser));
                    }
                    continue;
                }
                if (!"templates".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    builder.put(IndexTemplateMetaData.Builder.fromXContent(parser));
                }
            }
            return builder.build();
        }

        public static MetaData readFrom(StreamInput in) throws IOException {
            int i;
            Builder builder = new Builder();
            int size = in.readVInt();
            for (i = 0; i < size; ++i) {
                builder.put(IndexMetaData.Builder.readFrom(in));
            }
            size = in.readVInt();
            for (i = 0; i < size; ++i) {
                builder.put(IndexTemplateMetaData.Builder.readFrom(in));
            }
            return builder.build();
        }

        public static void writeTo(MetaData metaData, StreamOutput out) throws IOException {
            out.writeVInt(metaData.indices.size());
            for (IndexMetaData indexMetaData : metaData) {
                IndexMetaData.Builder.writeTo(indexMetaData, out);
            }
            out.writeVInt(metaData.templates.size());
            for (IndexTemplateMetaData template : metaData.templates.values()) {
                IndexTemplateMetaData.Builder.writeTo(template, out);
            }
        }
    }
}

