/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;

public class PlainShardsIterator
implements ShardsIterator {
    protected final List<ShardRouting> shards;
    private final int origIndex;
    private volatile int index;
    private volatile int counter = 0;

    public PlainShardsIterator(List<ShardRouting> shards) {
        this(shards, 0);
    }

    public PlainShardsIterator(List<ShardRouting> shards, int index) {
        this.shards = shards;
        this.origIndex = this.index = Math.abs(index);
    }

    @Override
    public Iterator<ShardRouting> iterator() {
        return this;
    }

    @Override
    public ShardsIterator reset() {
        this.counter = 0;
        this.index = this.origIndex;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.counter < this.size();
    }

    @Override
    public ShardRouting next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No shard found");
        }
        ++this.counter;
        return this.shardModulo(this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.shards.size();
    }

    @Override
    public int sizeActive() {
        int shardsActive = 0;
        for (ShardRouting shardRouting : this.shards) {
            if (!shardRouting.active()) continue;
            ++shardsActive;
        }
        return shardsActive;
    }

    @Override
    public boolean hasNextActive() {
        int counter = this.counter;
        int index = this.index;
        while (counter++ < this.size()) {
            ShardRouting shardRouting;
            if (!(shardRouting = this.shardModulo(index++)).active()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ShardRouting nextActive() throws NoSuchElementException {
        ShardRouting shardRouting = this.nextActiveOrNull();
        if (shardRouting == null) {
            throw new NoSuchElementException("No active shard found");
        }
        return shardRouting;
    }

    @Override
    public ShardRouting nextActiveOrNull() throws NoSuchElementException {
        int counter = this.counter;
        int index = this.index;
        while (counter++ < this.size()) {
            ShardRouting shardRouting;
            if (!(shardRouting = this.shardModulo(index++)).active()) continue;
            this.counter = counter;
            this.index = index;
            return shardRouting;
        }
        this.counter = counter;
        this.index = index;
        return null;
    }

    @Override
    public int sizeAssigned() {
        int shardsAssigned = 0;
        for (ShardRouting shardRouting : this.shards) {
            if (!shardRouting.assignedToNode()) continue;
            ++shardsAssigned;
        }
        return shardsAssigned;
    }

    @Override
    public boolean hasNextAssigned() {
        int counter = this.counter;
        int index = this.index;
        while (counter++ < this.size()) {
            ShardRouting shardRouting;
            if (!(shardRouting = this.shardModulo(index++)).assignedToNode()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ShardRouting nextAssigned() throws NoSuchElementException {
        ShardRouting shardRouting = this.nextAssignedOrNull();
        if (shardRouting == null) {
            throw new NoSuchElementException("No assigned shard found");
        }
        return shardRouting;
    }

    @Override
    public ShardRouting nextAssignedOrNull() {
        int counter = this.counter;
        int index = this.index;
        while (counter++ < this.size()) {
            ShardRouting shardRouting;
            if (!(shardRouting = this.shardModulo(index++)).assignedToNode()) continue;
            this.counter = counter;
            this.index = index;
            return shardRouting;
        }
        this.counter = counter;
        this.index = index;
        return null;
    }

    ShardRouting shardModulo(int counter) {
        return this.shards.get(counter % this.size());
    }
}

