/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.NodeAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ReplicaAfterPrimaryActiveNodeAllocation
extends NodeAllocation {
    @Inject
    public ReplicaAfterPrimaryActiveNodeAllocation(Settings settings) {
        super(settings);
    }

    @Override
    public NodeAllocation.Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            return NodeAllocation.Decision.YES;
        }
        MutableShardRouting primary = allocation.routingNodes().findPrimaryForReplica(shardRouting);
        if (primary == null || !primary.active()) {
            return NodeAllocation.Decision.NO;
        }
        return NodeAllocation.Decision.YES;
    }
}

