/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.ConstructorInjector;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.MembersInjectorImpl;
import org.elasticsearch.common.inject.MethodAspect;
import org.elasticsearch.common.inject.ProxyFactory;
import org.elasticsearch.common.inject.SingleParameterInjector;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.FailableCache;
import org.elasticsearch.common.inject.internal.ImmutableList;
import org.elasticsearch.common.inject.internal.Iterables;
import org.elasticsearch.common.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<TypeLiteral<?>, ConstructorInjector<?>> cache = new FailableCache<TypeLiteral<?>, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(TypeLiteral<?> type, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(type, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public <T> ConstructorInjector<T> get(TypeLiteral<T> key, Errors errors) throws ErrorsException {
        return this.cache.get(key, errors);
    }

    private <T> ConstructorInjector<T> createConstructor(TypeLiteral<T> type, Errors errors) throws ErrorsException {
        InjectionPoint injectionPoint;
        int numErrorsBefore = errors.size();
        try {
            injectionPoint = InjectionPoint.forConstructorOf(type);
        }
        catch (ConfigurationException e) {
            errors.merge(e.getErrorMessages());
            throw errors.toException();
        }
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(type, errors);
        ImmutableList<MethodAspect> injectorAspects = this.injector.state.getMethodAspects();
        ImmutableList<MethodAspect> methodAspects = membersInjector.getAddedAspects().isEmpty() ? injectorAspects : ImmutableList.copyOf(Iterables.concat(injectorAspects, membersInjector.getAddedAspects()));
        ProxyFactory factory = new ProxyFactory(injectionPoint, methodAspects);
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

