/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.CompactObjectInputStream;
import org.elasticsearch.common.io.CompactObjectOutputStream;
import org.elasticsearch.common.io.FastByteArrayInputStream;
import org.elasticsearch.common.io.FastByteArrayOutputStream;
import org.elasticsearch.common.io.ThrowableObjectInputStream;
import org.elasticsearch.common.io.ThrowableObjectOutputStream;

public final class Serializers {
    public static byte[] throwableToBytes(Throwable t) throws IOException {
        FastByteArrayOutputStream os = new FastByteArrayOutputStream();
        ThrowableObjectOutputStream oos = new ThrowableObjectOutputStream(os);
        oos.writeObject(t);
        oos.close();
        return os.unsafeByteArray();
    }

    public static Throwable throwableFromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        FastByteArrayInputStream is = new FastByteArrayInputStream(bytes);
        ThrowableObjectInputStream ois = new ThrowableObjectInputStream(is);
        Throwable t = (Throwable)ois.readObject();
        ois.close();
        return t;
    }

    public static void objectToStream(Serializable obj, DataOutput out) throws IOException {
        byte[] bytes = Serializers.objectToBytes(obj);
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static Object objectFromStream(DataInput in) throws ClassNotFoundException, IOException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        return Serializers.objectFromBytes(bytes);
    }

    public static byte[] objectToBytes(Serializable obj) throws IOException {
        FastByteArrayOutputStream os = new FastByteArrayOutputStream();
        CompactObjectOutputStream oos = new CompactObjectOutputStream(os);
        oos.writeObject(obj);
        oos.close();
        return os.unsafeByteArray();
    }

    public static Object objectFromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        FastByteArrayInputStream is = new FastByteArrayInputStream(bytes);
        CompactObjectInputStream ois = new CompactObjectInputStream(is);
        Object obj = ois.readObject();
        ois.close();
        return obj;
    }

    private Serializers() {
    }
}

