/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.lang.reflect.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public abstract class IndexWriters {
    private static ESLogger logger = Loggers.getLogger(IndexWriters.class);
    private static Field rollbackSegmentInfosField;
    private static final boolean docWriterReflection;

    public static SegmentInfos rollbackSegmentInfos(IndexWriter writer) throws Exception {
        return (SegmentInfos)rollbackSegmentInfosField.get(writer);
    }

    private IndexWriters() {
    }

    static {
        boolean docWriterReflectionX = false;
        try {
            rollbackSegmentInfosField = IndexWriter.class.getDeclaredField("rollbackSegmentInfos");
            rollbackSegmentInfosField.setAccessible(true);
            docWriterReflectionX = true;
        }
        catch (Exception e) {
            logger.warn("Failed to doc writer fields", e, new Object[0]);
        }
        docWriterReflection = docWriterReflectionX;
    }
}

