/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.OpenBitSetDISI;

public class DocIdSetCollector
extends Collector {
    private final Collector collector;
    private final OpenBitSetDISI docIdSet;
    private int base;

    public DocIdSetCollector(Collector collector, IndexReader reader) {
        this.collector = collector;
        this.docIdSet = new OpenBitSetDISI(reader.maxDoc());
    }

    public OpenBitSetDISI docIdSet() {
        return this.docIdSet;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.collector.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        this.collector.collect(doc);
        this.docIdSet.fastSet(this.base + doc);
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.base = docBase;
        this.collector.setNextReader(reader, docBase);
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.collector.acceptsDocsOutOfOrder();
    }
}

