/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lucene.docset.AndDocIdSet;
import org.elasticsearch.common.lucene.docset.AndDocSet;
import org.elasticsearch.common.lucene.docset.DocSet;

public class AndFilter
extends Filter {
    private final List<? extends Filter> filters;

    public AndFilter(List<? extends Filter> filters) {
        this.filters = filters;
    }

    public List<? extends Filter> filters() {
        return this.filters;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (this.filters.size() == 1) {
            return this.filters.get(0).getDocIdSet(reader);
        }
        ArrayList<DocIdSet> sets = Lists.newArrayListWithExpectedSize(this.filters.size());
        boolean allAreDocSet = true;
        for (Filter filter : this.filters) {
            DocIdSet set = filter.getDocIdSet(reader);
            if (set == null) {
                return DocSet.EMPTY_DOC_SET;
            }
            if (!(set instanceof DocSet)) {
                allAreDocSet = false;
            }
            sets.add(set);
        }
        if (allAreDocSet) {
            return new AndDocSet(sets);
        }
        return new AndDocIdSet(sets);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.filters ? 0 : ((Object)this.filters).hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        AndFilter other = (AndFilter)((Object)obj);
        return this.equalFilters(this.filters, other.filters);
    }

    private boolean equalFilters(List<? extends Filter> filters1, List<? extends Filter> filters2) {
        return filters1 == filters2 || filters1 != null && ((Object)filters1).equals(filters2);
    }
}

