/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.lucene.docset.AllDocSet;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.NotDocIdSet;
import org.elasticsearch.common.lucene.docset.NotDocSet;

public class NotFilter
extends Filter {
    private final Filter filter;

    public NotFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter filter() {
        return this.filter;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocIdSet set = this.filter.getDocIdSet(reader);
        if (set == null) {
            return new AllDocSet(reader.maxDoc());
        }
        if (set instanceof DocSet) {
            return new NotDocSet((DocSet)set, reader.maxDoc());
        }
        return new NotDocIdSet(set, reader.maxDoc());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NotFilter notFilter = (NotFilter)((Object)o);
        return !(this.filter == null ? notFilter.filter != null : !this.filter.equals(notFilter.filter));
    }

    public int hashCode() {
        return this.filter != null ? this.filter.hashCode() : 0;
    }
}

