/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Payload;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.elasticsearch.common.Numbers;

public class UidField
extends AbstractField {
    private String uid;
    private long version;
    private final UidPayloadTokenStream tokenStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocIdAndVersion loadDocIdAndVersion(IndexReader reader, Term term) {
        int docId = -1;
        TermPositions uid = null;
        try {
            uid = reader.termPositions(term);
            if (!uid.next()) {
                DocIdAndVersion docIdAndVersion = null;
                return docIdAndVersion;
            }
            docId = uid.doc();
            uid.nextPosition();
            if (!uid.isPayloadAvailable()) {
                DocIdAndVersion docIdAndVersion = new DocIdAndVersion(docId, -2L, reader);
                return docIdAndVersion;
            }
            if (uid.getPayloadLength() < 8) {
                DocIdAndVersion docIdAndVersion = new DocIdAndVersion(docId, -2L, reader);
                return docIdAndVersion;
            }
            byte[] payload = uid.getPayload(new byte[8], 0);
            DocIdAndVersion docIdAndVersion = new DocIdAndVersion(docId, Numbers.bytesToLong(payload), reader);
            return docIdAndVersion;
        }
        catch (Exception e) {
            DocIdAndVersion docIdAndVersion = new DocIdAndVersion(docId, -2L, reader);
            return docIdAndVersion;
        }
        finally {
            if (uid != null) {
                try {
                    uid.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long loadVersion(IndexReader reader, Term term) {
        TermPositions uid = null;
        try {
            uid = reader.termPositions(term);
            if (!uid.next()) {
                long l = -1L;
                return l;
            }
            uid.nextPosition();
            if (!uid.isPayloadAvailable()) {
                long l = -2L;
                return l;
            }
            if (uid.getPayloadLength() < 8) {
                long l = -2L;
                return l;
            }
            byte[] payload = uid.getPayload(new byte[8], 0);
            long l = Numbers.bytesToLong(payload);
            return l;
        }
        catch (Exception e) {
            long l = -2L;
            return l;
        }
        finally {
            if (uid != null) {
                try {
                    uid.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public UidField(String name, String uid, long version) {
        super(name, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO);
        this.uid = uid;
        this.version = version;
        this.omitTermFreqAndPositions = false;
        this.tokenStream = new UidPayloadTokenStream(this);
    }

    public void setOmitTermFreqAndPositions(boolean omitTermFreqAndPositions) {
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String stringValue() {
        return this.uid;
    }

    public Reader readerValue() {
        return null;
    }

    public long version() {
        return this.version;
    }

    public void version(long version) {
        this.version = version;
    }

    public TokenStream tokenStreamValue() {
        return this.tokenStream;
    }

    public static final class UidPayloadTokenStream
    extends TokenStream {
        private final PayloadAttribute payloadAttribute = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final UidField field;
        private boolean added = false;

        public UidPayloadTokenStream(UidField field) {
            this.field = field;
        }

        public void reset() throws IOException {
            this.added = false;
        }

        public final boolean incrementToken() throws IOException {
            if (this.added) {
                return false;
            }
            this.termAtt.setLength(0);
            this.termAtt.append(this.field.uid);
            this.payloadAttribute.setPayload(new Payload(Numbers.longToBytes(this.field.version())));
            this.added = true;
            return true;
        }
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final long version;
        public final IndexReader reader;

        public DocIdAndVersion(int docId, long version, IndexReader reader) {
            this.docId = docId;
            this.version = version;
            this.reader = reader;
        }
    }
}

