/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.UUID;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.elect.ElectMasterService;
import org.elasticsearch.discovery.zen.fd.MasterFaultDetection;
import org.elasticsearch.discovery.zen.fd.NodesFaultDetection;
import org.elasticsearch.discovery.zen.membership.MembershipAction;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.ZenPingService;
import org.elasticsearch.discovery.zen.publish.PublishClusterStateAction;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class ZenDiscovery
extends AbstractLifecycleComponent<Discovery>
implements Discovery,
DiscoveryNodesProvider {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final ClusterName clusterName;
    private final ZenPingService pingService;
    private final MasterFaultDetection masterFD;
    private final NodesFaultDetection nodesFD;
    private final PublishClusterStateAction publishClusterState;
    private final MembershipAction membership;
    private final TimeValue initialPingTimeout;
    private final boolean sendLeaveRequest;
    private final ElectMasterService electMaster;
    private DiscoveryNode localNode;
    private final CopyOnWriteArrayList<InitialStateDiscoveryListener> initialStateListeners = new CopyOnWriteArrayList();
    private volatile boolean master = false;
    private volatile DiscoveryNodes latestDiscoNodes;
    private volatile Thread currentJoinThread;
    private final AtomicBoolean initialStateSent = new AtomicBoolean();

    @Inject
    public ZenDiscovery(Settings settings, ClusterName clusterName, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ZenPingService pingService) {
        super(settings);
        this.clusterName = clusterName;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.pingService = pingService;
        this.initialPingTimeout = this.componentSettings.getAsTime("ping_timeout", this.componentSettings.getAsTime("initial_ping_timeout", TimeValue.timeValueSeconds(3L)));
        this.sendLeaveRequest = this.componentSettings.getAsBoolean("send_leave_request", true);
        this.logger.debug("using initial_ping_timeout [{}]", this.initialPingTimeout);
        this.electMaster = new ElectMasterService(settings);
        this.masterFD = new MasterFaultDetection(settings, threadPool, transportService, this);
        this.masterFD.addListener(new MasterNodeFailureListener());
        this.nodesFD = new NodesFaultDetection(settings, threadPool, transportService);
        this.nodesFD.addListener(new NodeFailureListener());
        this.publishClusterState = new PublishClusterStateAction(settings, transportService, this, new NewClusterStateListener());
        this.pingService.setNodesProvider(this);
        this.membership = new MembershipAction(settings, transportService, this, new MembershipListener());
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        Map<String, String> nodeAttributes = DiscoveryNode.buildCommonNodesAttributes(this.settings);
        String nodeId = UUID.randomBase64UUID();
        this.localNode = new DiscoveryNode(this.settings.get("name"), nodeId, this.transportService.boundAddress().publishAddress(), nodeAttributes);
        this.latestDiscoNodes = new DiscoveryNodes.Builder().put(this.localNode).localNodeId(this.localNode.id()).build();
        this.nodesFD.updateNodes(this.latestDiscoNodes);
        this.pingService.start();
        this.asyncJoinCluster();
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.pingService.stop();
        this.masterFD.stop("zen disco stop");
        this.nodesFD.stop();
        this.initialStateSent.set(false);
        if (this.sendLeaveRequest) {
            if (!this.master && this.latestDiscoNodes.masterNode() != null) {
                try {
                    this.membership.sendLeaveRequestBlocking(this.latestDiscoNodes.masterNode(), this.localNode, TimeValue.timeValueSeconds(1L));
                }
                catch (Exception e) {
                    this.logger.debug("failed to send leave request to master [{}]", e, this.latestDiscoNodes.masterNode());
                }
            } else {
                DiscoveryNode[] possibleMasters;
                for (DiscoveryNode possibleMaster : possibleMasters = this.electMaster.nextPossibleMasters(this.latestDiscoNodes.nodes().values(), 5)) {
                    if (this.localNode.equals(possibleMaster)) continue;
                    try {
                        this.membership.sendLeaveRequest(this.latestDiscoNodes.masterNode(), possibleMaster);
                    }
                    catch (Exception e) {
                        this.logger.debug("failed to send leave request from master [{}] to possible master [{}]", e, this.latestDiscoNodes.masterNode(), possibleMaster);
                    }
                }
            }
        }
        this.master = false;
        if (this.currentJoinThread != null) {
            try {
                this.currentJoinThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.masterFD.close();
        this.nodesFD.close();
        this.publishClusterState.close();
        this.membership.close();
        this.pingService.close();
    }

    @Override
    public DiscoveryNode localNode() {
        return this.localNode;
    }

    @Override
    public void addListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.add(listener);
    }

    @Override
    public void removeListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.remove(listener);
    }

    @Override
    public String nodeDescription() {
        return this.clusterName.value() + "/" + this.localNode.id();
    }

    @Override
    public DiscoveryNodes nodes() {
        DiscoveryNodes latestNodes = this.latestDiscoNodes;
        if (latestNodes != null) {
            return latestNodes;
        }
        return DiscoveryNodes.newNodesBuilder().put(this.localNode).localNodeId(this.localNode.id()).build();
    }

    @Override
    public void publish(ClusterState clusterState) {
        if (!this.master) {
            throw new ElasticSearchIllegalStateException("Shouldn't publish state when not master");
        }
        this.latestDiscoNodes = clusterState.nodes();
        this.nodesFD.updateNodes(clusterState.nodes());
        this.publishClusterState.publish(clusterState);
    }

    private void asyncJoinCluster() {
        this.threadPool.cached().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ZenDiscovery.this.currentJoinThread = Thread.currentThread();
                try {
                    ZenDiscovery.this.innterJoinCluster();
                }
                finally {
                    ZenDiscovery.this.currentJoinThread = null;
                }
            }
        });
    }

    private void innterJoinCluster() {
        boolean retry = true;
        while (retry) {
            ClusterState clusterState;
            if (this.lifecycle.stoppedOrClosed()) {
                return;
            }
            retry = false;
            DiscoveryNode masterNode = this.findMaster();
            if (masterNode == null) {
                retry = true;
                continue;
            }
            if (this.localNode.equals(masterNode)) {
                this.master = true;
                this.nodesFD.start();
                this.clusterService.submitStateUpdateTask("zen-disco-join (elected_as_master)", new ProcessedClusterStateUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        DiscoveryNodes.Builder builder = new DiscoveryNodes.Builder().localNodeId(ZenDiscovery.this.localNode.id()).masterNodeId(ZenDiscovery.this.localNode.id()).put(ZenDiscovery.this.localNode);
                        ZenDiscovery.this.latestDiscoNodes = builder.build();
                        ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(Discovery.NO_MASTER_BLOCK).build();
                        return ClusterState.newClusterStateBuilder().state(currentState).nodes(builder).blocks(clusterBlocks).build();
                    }

                    @Override
                    public void clusterStateProcessed(ClusterState clusterState) {
                        ZenDiscovery.this.sendInitialStateEventIfNeeded();
                    }
                });
                continue;
            }
            this.master = false;
            try {
                this.transportService.connectToNode(masterNode);
            }
            catch (Exception e) {
                this.logger.warn("failed to connect to master [{}], retrying...", e, masterNode);
                retry = true;
                continue;
            }
            try {
                clusterState = this.membership.sendJoinRequestBlocking(masterNode, this.localNode, this.initialPingTimeout);
            }
            catch (Exception e) {
                if (e instanceof ElasticSearchException) {
                    this.logger.info("failed to send join request to master [{}], reason [{}]", masterNode, ((ElasticSearchException)e).getDetailedMessage());
                } else {
                    this.logger.info("failed to send join request to master [{}], reason [{}]", masterNode, e.getMessage());
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("detailed failed reason", e, new Object[0]);
                }
                retry = true;
                continue;
            }
            this.masterFD.start(masterNode, "initial_join");
            final MetaData metaData = clusterState.metaData();
            final long version = clusterState.version();
            this.clusterService.submitStateUpdateTask("zen-disco-join (detected master)", new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(Discovery.NO_MASTER_BLOCK).build();
                    DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.newNodesBuilder().putAll(currentState.nodes()).put(ZenDiscovery.this.localNode).localNodeId(ZenDiscovery.this.localNode.id());
                    return ClusterState.newClusterStateBuilder().state(currentState).nodes(nodesBuilder).blocks(clusterBlocks).metaData(metaData).version(version).build();
                }

                @Override
                public void clusterStateProcessed(ClusterState clusterState) {
                }
            });
        }
    }

    private void handleNodeFailure(final DiscoveryNode node, String reason) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (!this.master) {
            return;
        }
        this.clusterService.submitStateUpdateTask("zen-disco-node_failed(" + node + "), reason " + reason, new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                DiscoveryNodes.Builder builder = new DiscoveryNodes.Builder().putAll(currentState.nodes()).remove(node.id());
                ZenDiscovery.this.latestDiscoNodes = builder.build();
                return ClusterState.newClusterStateBuilder().state(currentState).nodes(ZenDiscovery.this.latestDiscoNodes).build();
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                ZenDiscovery.this.sendInitialStateEventIfNeeded();
            }
        });
    }

    private void handleMasterGone(final DiscoveryNode masterNode, final String reason) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (this.master) {
            return;
        }
        this.logger.info("master_left [{}], reason [{}]", masterNode, reason);
        this.clusterService.submitStateUpdateTask("zen-disco-master_failed (" + masterNode + ")", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (!masterNode.id().equals(currentState.nodes().masterNodeId())) {
                    return currentState;
                }
                ClusterBlocks clusterBlocks = currentState.blocks();
                MetaData metaData = currentState.metaData();
                RoutingTable routingTable = currentState.routingTable();
                ArrayList<DiscoveryNode> nodes = Lists.newArrayList(currentState.nodes().nodes().values());
                nodes.remove(masterNode);
                DiscoveryNode electedMaster = ZenDiscovery.this.electMaster.electMaster(nodes);
                if (ZenDiscovery.this.localNode.equals(electedMaster)) {
                    ZenDiscovery.this.master = true;
                    ZenDiscovery.this.masterFD.stop("got elected as new master since master left (reason = " + reason + ")");
                    ZenDiscovery.this.nodesFD.start();
                    DiscoveryNodes.Builder builder = DiscoveryNodes.newNodesBuilder().putAll(currentState.nodes()).remove(masterNode.id()).masterNodeId(ZenDiscovery.this.localNode.id());
                    ZenDiscovery.this.latestDiscoNodes = builder.build();
                    return ClusterState.newClusterStateBuilder().state(currentState).nodes(ZenDiscovery.this.latestDiscoNodes).build();
                }
                ZenDiscovery.this.nodesFD.stop();
                DiscoveryNodes.Builder builder = DiscoveryNodes.newNodesBuilder().putAll(currentState.nodes()).remove(masterNode.id());
                if (electedMaster != null) {
                    builder.masterNodeId(electedMaster.id());
                    ZenDiscovery.this.masterFD.restart(electedMaster, "possible elected master since master left (reason = " + reason + ")");
                } else {
                    ZenDiscovery.this.logger.warn("master_left and no other node elected to become master, current nodes: {}", nodes);
                    builder.masterNodeId(null);
                    clusterBlocks = ClusterBlocks.builder().blocks(clusterBlocks).addGlobalBlock(Discovery.NO_MASTER_BLOCK).build();
                    if (currentState.nodes().localNode().dataNode()) {
                        metaData = MetaData.newMetaDataBuilder().build();
                        routingTable = RoutingTable.newRoutingTableBuilder().build();
                    }
                    ZenDiscovery.this.masterFD.stop("no master elected since master left (reason = " + reason + ")");
                    ZenDiscovery.this.asyncJoinCluster();
                }
                ZenDiscovery.this.latestDiscoNodes = builder.build();
                return ClusterState.newClusterStateBuilder().state(currentState).blocks(clusterBlocks).nodes(ZenDiscovery.this.latestDiscoNodes).metaData(metaData).routingTable(routingTable).build();
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                ZenDiscovery.this.sendInitialStateEventIfNeeded();
            }
        });
    }

    void handleNewClusterStateFromMaster(final ClusterState clusterState) {
        if (this.master) {
            this.logger.warn("master should not receive new cluster state from [{}]", clusterState.nodes().masterNode());
        } else if (clusterState.nodes().localNode() == null) {
            this.logger.warn("received a cluster state from [{}] and not part of the cluster, should not happen", clusterState.nodes().masterNode());
        } else {
            this.clusterService.submitStateUpdateTask("zen-disco-receive(from master [" + clusterState.nodes().masterNode() + "])", new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ZenDiscovery.this.latestDiscoNodes = clusterState.nodes();
                    if (ZenDiscovery.this.masterFD.masterNode() == null || !ZenDiscovery.this.masterFD.masterNode().equals(ZenDiscovery.this.latestDiscoNodes.masterNode())) {
                        ZenDiscovery.this.masterFD.restart(ZenDiscovery.this.latestDiscoNodes.masterNode(), "new cluster stare received and we monitor the wrong master [" + ZenDiscovery.this.masterFD.masterNode() + "]");
                    }
                    return clusterState;
                }

                @Override
                public void clusterStateProcessed(ClusterState clusterState2) {
                    ZenDiscovery.this.sendInitialStateEventIfNeeded();
                }
            });
        }
    }

    private void handleLeaveRequest(final DiscoveryNode node) {
        if (this.master) {
            this.clusterService.submitStateUpdateTask("zen-disco-node_left(" + node + ")", new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    DiscoveryNodes.Builder builder = new DiscoveryNodes.Builder().putAll(currentState.nodes()).remove(node.id());
                    ZenDiscovery.this.latestDiscoNodes = builder.build();
                    return ClusterState.newClusterStateBuilder().state(currentState).nodes(ZenDiscovery.this.latestDiscoNodes).build();
                }
            });
        } else {
            this.handleMasterGone(node, "shut_down");
        }
    }

    private ClusterState handleJoinRequest(final DiscoveryNode node) {
        if (!this.master) {
            throw new ElasticSearchIllegalStateException("Node [" + this.localNode + "] not master for join request from [" + node + "]");
        }
        ClusterState state = this.clusterService.state();
        if (!this.transportService.addressSupported(node.address().getClass())) {
            this.logger.warn("received a wrong address type from [{}], ignoring...", node);
        } else {
            this.transportService.connectToNode(node);
            state = this.clusterService.state();
            this.clusterService.submitStateUpdateTask("zen-disco-receive(join from node[" + node + "])", new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    if (currentState.nodes().nodeExists(node.id())) {
                        ZenDiscovery.this.logger.warn("received a join request for an existing node [{}]", node);
                        return ClusterState.builder().state(currentState).build();
                    }
                    return ClusterState.newClusterStateBuilder().state(currentState).nodes(currentState.nodes().newNode(node)).build();
                }
            });
        }
        return state;
    }

    private DiscoveryNode findMaster() {
        ZenPing.PingResponse[] pingResponses = this.pingService.pingAndWait(this.initialPingTimeout);
        if (pingResponses == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("ping responses:");
            if (pingResponses.length == 0) {
                sb.append(" {none}");
            } else {
                for (ZenPing.PingResponse pingResponse : pingResponses) {
                    sb.append("\n\t--> ").append("target [").append(pingResponse.target()).append("], master [").append(pingResponse.master()).append("]");
                }
            }
            this.logger.debug(sb.toString(), new Object[0]);
        }
        ArrayList<DiscoveryNode> pingMasters = Lists.newArrayList();
        for (ZenPing.PingResponse pingResponse : pingResponses) {
            if (pingResponse.master() == null) continue;
            pingMasters.add(pingResponse.master());
        }
        if (pingMasters.isEmpty()) {
            ArrayList<DiscoveryNode> possibleMasterNodes = Lists.newArrayList();
            possibleMasterNodes.add(this.localNode);
            for (ZenPing.PingResponse pingResponse : pingResponses) {
                possibleMasterNodes.add(pingResponse.target());
            }
            DiscoveryNode electedMaster = this.electMaster.electMaster(possibleMasterNodes);
            if (this.localNode.equals(electedMaster)) {
                return this.localNode;
            }
        } else {
            DiscoveryNode electedMaster = this.electMaster.electMaster(pingMasters);
            if (electedMaster != null) {
                return electedMaster;
            }
        }
        return null;
    }

    private void sendInitialStateEventIfNeeded() {
        if (this.initialStateSent.compareAndSet(false, true)) {
            for (InitialStateDiscoveryListener listener : this.initialStateListeners) {
                listener.initialStateProcessed();
            }
        }
    }

    private class MasterNodeFailureListener
    implements MasterFaultDetection.Listener {
        private MasterNodeFailureListener() {
        }

        @Override
        public void onMasterFailure(DiscoveryNode masterNode, String reason) {
            ZenDiscovery.this.handleMasterGone(masterNode, reason);
        }

        @Override
        public void onDisconnectedFromMaster() {
            DiscoveryNode masterNode = ZenDiscovery.this.latestDiscoNodes.masterNode();
            try {
                ZenDiscovery.this.membership.sendJoinRequest(masterNode, ZenDiscovery.this.localNode);
            }
            catch (Exception e) {
                ZenDiscovery.this.logger.warn("failed to send join request on disconnection from master [{}]", masterNode);
            }
        }
    }

    private class NodeFailureListener
    implements NodesFaultDetection.Listener {
        private NodeFailureListener() {
        }

        @Override
        public void onNodeFailure(DiscoveryNode node, String reason) {
            ZenDiscovery.this.handleNodeFailure(node, reason);
        }
    }

    private class MembershipListener
    implements MembershipAction.MembershipListener {
        private MembershipListener() {
        }

        @Override
        public ClusterState onJoin(DiscoveryNode node) {
            return ZenDiscovery.this.handleJoinRequest(node);
        }

        @Override
        public void onLeave(DiscoveryNode node) {
            ZenDiscovery.this.handleLeaveRequest(node);
        }
    }

    private class NewClusterStateListener
    implements PublishClusterStateAction.NewClusterStateListener {
        private NewClusterStateListener() {
        }

        @Override
        public void onNewClusterState(ClusterState clusterState) {
            ZenDiscovery.this.handleNewClusterStateFromMaster(clusterState);
        }
    }
}

