/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.publish;

import java.io.IOException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.VoidStreamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.VoidTransportResponseHandler;

public class PublishClusterStateAction
extends AbstractComponent {
    private final TransportService transportService;
    private final DiscoveryNodesProvider nodesProvider;
    private final NewClusterStateListener listener;

    public PublishClusterStateAction(Settings settings, TransportService transportService, DiscoveryNodesProvider nodesProvider, NewClusterStateListener listener) {
        super(settings);
        this.transportService = transportService;
        this.nodesProvider = nodesProvider;
        this.listener = listener;
        transportService.registerHandler("discovery/zen/publish", new PublishClusterStateRequestHandler());
    }

    public void close() {
        this.transportService.removeHandler("discovery/zen/publish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(ClusterState clusterState) {
        byte[] clusterStateInBytes;
        DiscoveryNode localNode = this.nodesProvider.nodes().localNode();
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        try {
            HandlesStreamOutput stream = cachedEntry.cachedHandlesLzfBytes();
            ClusterState.Builder.writeTo(clusterState, stream);
            stream.flush();
            clusterStateInBytes = cachedEntry.bytes().copiedByteArray();
        }
        catch (Exception e) {
            this.logger.warn("failed to serialize cluster_state before publishing it to nodes", e, new Object[0]);
            return;
        }
        finally {
            CachedStreamOutput.pushEntry(cachedEntry);
        }
        for (final DiscoveryNode node : clusterState.nodes()) {
            if (node.equals(localNode)) continue;
            this.transportService.sendRequest(node, "discovery/zen/publish", new PublishClusterStateRequest(clusterStateInBytes), TransportRequestOptions.options().withHighType().withCompress(false), new VoidTransportResponseHandler("same"){

                @Override
                public void handleException(TransportException exp) {
                    PublishClusterStateAction.this.logger.debug("failed to send cluster state to [{}], should be detected as failed soon...", exp, node);
                }
            });
        }
    }

    private class PublishClusterStateRequestHandler
    extends BaseTransportRequestHandler<PublishClusterStateRequest> {
        static final String ACTION = "discovery/zen/publish";

        private PublishClusterStateRequestHandler() {
        }

        @Override
        public PublishClusterStateRequest newInstance() {
            return new PublishClusterStateRequest();
        }

        @Override
        public void messageReceived(PublishClusterStateRequest request, TransportChannel channel) throws Exception {
            HandlesStreamInput in = CachedStreamInput.cachedHandlesLzf(new BytesStreamInput(request.clusterStateInBytes));
            ClusterState clusterState = ClusterState.Builder.readFrom(in, PublishClusterStateAction.this.nodesProvider.nodes().localNode());
            PublishClusterStateAction.this.listener.onNewClusterState(clusterState);
            channel.sendResponse(VoidStreamable.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private class PublishClusterStateRequest
    implements Streamable {
        private byte[] clusterStateInBytes;

        private PublishClusterStateRequest() {
        }

        private PublishClusterStateRequest(byte[] clusterStateInBytes) {
            this.clusterStateInBytes = clusterStateInBytes;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.clusterStateInBytes = new byte[in.readVInt()];
            in.readFully(this.clusterStateInBytes);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.clusterStateInBytes.length);
            out.writeBytes(this.clusterStateInBytes);
        }
    }

    public static interface NewClusterStateListener {
        public void onNewClusterState(ClusterState var1);
    }
}

