/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.phonetic;

import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.codec.Encoder;
import org.elasticsearch.common.codec.language.Caverphone1;
import org.elasticsearch.common.codec.language.Caverphone2;
import org.elasticsearch.common.codec.language.ColognePhonetic;
import org.elasticsearch.common.codec.language.DoubleMetaphone;
import org.elasticsearch.common.codec.language.Metaphone;
import org.elasticsearch.common.codec.language.RefinedSoundex;
import org.elasticsearch.common.codec.language.Soundex;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.analysis.phonetic.DoubleMetaphoneFilter;
import org.elasticsearch.index.analysis.phonetic.PhoneticFilter;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class PhoneticTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Encoder encoder;
    private final boolean inject;

    @Inject
    public PhoneticTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.inject = settings.getAsBoolean("replace", true);
        String encoder = settings.get("encoder");
        if (encoder == null) {
            throw new ElasticSearchIllegalArgumentException("encoder must be set on phonetic token filter");
        }
        if ("metaphone".equalsIgnoreCase(encoder)) {
            this.encoder = new Metaphone();
        } else if ("soundex".equalsIgnoreCase(encoder)) {
            this.encoder = new Soundex();
        } else if ("caverphone1".equalsIgnoreCase(encoder)) {
            this.encoder = new Caverphone1();
        } else if ("caverphone2".equalsIgnoreCase(encoder)) {
            this.encoder = new Caverphone2();
        } else if ("caverphone".equalsIgnoreCase(encoder)) {
            this.encoder = new Caverphone2();
        } else if ("refined_soundex".equalsIgnoreCase(encoder) || "refinedSoundex".equalsIgnoreCase(encoder)) {
            this.encoder = new RefinedSoundex();
        } else if ("cologne".equalsIgnoreCase(encoder)) {
            this.encoder = new ColognePhonetic();
        } else if ("double_metaphone".equalsIgnoreCase(encoder) || "doubleMetaphone".equalsIgnoreCase(encoder)) {
            DoubleMetaphone doubleMetaphone = new DoubleMetaphone();
            doubleMetaphone.setMaxCodeLen(settings.getAsInt("max_code_len", doubleMetaphone.getMaxCodeLen()));
            this.encoder = doubleMetaphone;
        } else {
            throw new ElasticSearchIllegalArgumentException("unknown encoder [" + encoder + "] for phonetic token filter");
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.encoder instanceof DoubleMetaphone) {
            return new DoubleMetaphoneFilter(tokenStream, (DoubleMetaphone)this.encoder, this.inject);
        }
        return new PhoneticFilter(tokenStream, this.encoder, this.name(), this.inject);
    }
}

