/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.resident;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.collect.MapEvictionListener;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.support.AbstractConcurrentMapFilterCache;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;

public class ResidentFilterCache
extends AbstractConcurrentMapFilterCache
implements MapEvictionListener<Filter, DocSet> {
    private final IndexSettingsService indexSettingsService;
    private volatile int maxSize;
    private volatile TimeValue expire;
    private final AtomicLong evictions = new AtomicLong();
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public ResidentFilterCache(Index index, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService) {
        super(index, indexSettings);
        this.indexSettingsService = indexSettingsService;
        this.maxSize = indexSettings.getAsInt("index.cache.filter.max_size", this.componentSettings.getAsInt("max_size", 1000));
        this.expire = indexSettings.getAsTime("index.cache.filter.expire", this.componentSettings.getAsTime("expire", null));
        this.logger.debug("using [resident] filter cache with max_size [{}], expire [{}]", this.maxSize, this.expire);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public void close() {
        this.indexSettingsService.removeListener(this.applySettings);
        super.close();
    }

    @Override
    protected ConcurrentMap<Filter, DocSet> buildFilterMap() {
        MapMaker mapMaker = new MapMaker();
        if (this.maxSize != -1) {
            mapMaker.maximumSize(this.maxSize);
        }
        if (this.expire != null) {
            mapMaker.expireAfterAccess(this.expire.nanos(), TimeUnit.NANOSECONDS);
        }
        mapMaker.evictionListener(this);
        return mapMaker.makeMap();
    }

    @Override
    public String type() {
        return "resident";
    }

    @Override
    public long evictions() {
        return this.evictions.get();
    }

    @Override
    public void onEviction(Filter filter, DocSet docSet) {
        this.evictions.incrementAndGet();
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int maxSize = settings.getAsInt("index.cache.filter.max_size", ResidentFilterCache.this.maxSize);
            TimeValue expire = settings.getAsTime("index.cache.filter.expire", ResidentFilterCache.this.expire);
            boolean changed = false;
            if (maxSize != ResidentFilterCache.this.maxSize) {
                ResidentFilterCache.this.logger.info("updating index.cache.filter.max_size from [{}] to [{}]", ResidentFilterCache.this.maxSize, maxSize);
                changed = true;
                ResidentFilterCache.this.maxSize = maxSize;
            }
            if (!Objects.equal(expire, ResidentFilterCache.this.expire)) {
                ResidentFilterCache.this.logger.info("updating index.cache.filter.expire from [{}] to [{}]", ResidentFilterCache.this.expire, expire);
                changed = true;
                ResidentFilterCache.this.expire = expire;
            }
            if (changed) {
                ResidentFilterCache.this.clear();
            }
        }
    }
}

