/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.doubles;

import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.NumericFieldDataComparator;

public class DoubleFieldDataComparator
extends NumericFieldDataComparator {
    private final double[] values;
    private double bottom;

    public DoubleFieldDataComparator(int numHits, String fieldName, FieldDataCache fieldDataCache) {
        super(fieldName, fieldDataCache);
        this.values = new double[numHits];
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.DOUBLE;
    }

    public int compare(int slot1, int slot2) {
        double v1 = this.values[slot1];
        double v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    public int compareBottom(int doc) {
        double v2 = this.currentFieldData.doubleValue(doc);
        if (this.bottom > v2) {
            return 1;
        }
        if (this.bottom < v2) {
            return -1;
        }
        return 0;
    }

    public void copy(int slot, int doc) {
        this.values[slot] = this.currentFieldData.doubleValue(doc);
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Double.valueOf(this.values[slot]);
    }
}

