/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.ints;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.trove.list.array.TIntArrayList;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.ints.IntDocFieldData;
import org.elasticsearch.index.field.data.ints.MultiValueIntFieldData;
import org.elasticsearch.index.field.data.ints.SingleValueIntFieldData;
import org.elasticsearch.index.field.data.support.FieldDataLoader;

public abstract class IntFieldData
extends NumericFieldData<IntDocFieldData> {
    static final int[] EMPTY_INT_ARRAY = new int[0];
    protected final int[] values;

    protected IntFieldData(String fieldName, int[] values) {
        super(fieldName);
        this.values = values;
    }

    @Override
    protected long computeSizeInBytes() {
        return 4 * this.values.length + RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    public final int[] values() {
        return this.values;
    }

    public abstract int value(int var1);

    public abstract int[] values(int var1);

    @Override
    public IntDocFieldData docFieldData(int docId) {
        return (IntDocFieldData)super.docFieldData(docId);
    }

    @Override
    protected IntDocFieldData createFieldData() {
        return new IntDocFieldData(this);
    }

    @Override
    public String stringValue(int docId) {
        return Integer.toString(this.value(docId));
    }

    @Override
    public void forEachValue(FieldData.StringValueProc proc) {
        for (int i = 1; i < this.values.length; ++i) {
            proc.onValue(Integer.toString(this.values[i]));
        }
    }

    @Override
    public byte byteValue(int docId) {
        return (byte)this.value(docId);
    }

    @Override
    public short shortValue(int docId) {
        return (short)this.value(docId);
    }

    @Override
    public int intValue(int docId) {
        return this.value(docId);
    }

    @Override
    public long longValue(int docId) {
        return this.value(docId);
    }

    @Override
    public float floatValue(int docId) {
        return this.value(docId);
    }

    @Override
    public double doubleValue(int docId) {
        return this.value(docId);
    }

    @Override
    public FieldDataType type() {
        return FieldDataType.DefaultTypes.INT;
    }

    public void forEachValue(ValueProc proc) {
        for (int i = 1; i < this.values.length; ++i) {
            proc.onValue(this.values[i]);
        }
    }

    public abstract void forEachValueInDoc(int var1, ValueInDocProc var2);

    public static IntFieldData load(IndexReader reader, String field) throws IOException {
        return FieldDataLoader.load(reader, field, new IntTypeLoader());
    }

    static class IntTypeLoader
    extends FieldDataLoader.FreqsTypeLoader<IntFieldData> {
        private final TIntArrayList terms = new TIntArrayList();

        IntTypeLoader() {
            this.terms.add(0);
        }

        @Override
        public void collectTerm(String term) {
            this.terms.add(FieldCache.NUMERIC_UTILS_INT_PARSER.parseInt(term));
        }

        @Override
        public IntFieldData buildSingleValue(String field, int[] ordinals) {
            return new SingleValueIntFieldData(field, ordinals, this.terms.toArray());
        }

        @Override
        public IntFieldData buildMultiValue(String field, int[][] ordinals) {
            return new MultiValueIntFieldData(field, ordinals, this.terms.toArray());
        }
    }

    public static interface ValueInDocProc {
        public void onValue(int var1, int var2);

        public void onMissing(int var1);
    }

    public static interface ValueProc {
        public void onValue(int var1);
    }
}

