/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.util.concurrent.ThreadSafe;
import org.elasticsearch.index.mapper.AllFieldMapper;
import org.elasticsearch.index.mapper.BoostFieldMapper;
import org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.elasticsearch.index.mapper.FailedToGenerateSourceMapperException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.IndexFieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TypeFieldMapper;
import org.elasticsearch.index.mapper.UidFieldMapper;

@ThreadSafe
public interface DocumentMapper {
    public void close();

    public String type();

    public CompressedString mappingSource();

    public ImmutableMap<String, Object> meta();

    public void refreshSource() throws FailedToGenerateSourceMapperException;

    public UidFieldMapper uidMapper();

    public IdFieldMapper idMapper();

    public TypeFieldMapper typeMapper();

    public IndexFieldMapper indexMapper();

    public SourceFieldMapper sourceMapper();

    public BoostFieldMapper boostMapper();

    public AllFieldMapper allFieldMapper();

    public RoutingFieldMapper routingFieldMapper();

    public ParentFieldMapper parentFieldMapper();

    public DocumentFieldMappers mappers();

    public Analyzer indexAnalyzer();

    public Analyzer searchAnalyzer();

    public Filter typeFilter();

    public ParsedDocument parse(byte[] var1) throws MapperParsingException;

    public ParsedDocument parse(String var1, String var2, byte[] var3) throws MapperParsingException;

    public ParsedDocument parse(SourceToParse var1) throws MapperParsingException;

    public ParsedDocument parse(SourceToParse var1, @Nullable ParseListener var2) throws MapperParsingException;

    public MergeResult merge(DocumentMapper var1, MergeFlags var2) throws MergeMappingException;

    public void addFieldMapperListener(FieldMapperListener var1, boolean var2);

    public static class ParseListenerAdapter
    implements ParseListener {
        public boolean beforeFieldAdded(FieldMapper fieldMapper, Fieldable fieldable, Object parseContext) {
            return true;
        }
    }

    public static interface ParseListener<ParseContext> {
        public static final ParseListener EMPTY = new ParseListenerAdapter();

        public boolean beforeFieldAdded(FieldMapper var1, Fieldable var2, ParseContext var3);
    }

    public static class MergeFlags {
        private boolean simulate = true;

        public static MergeFlags mergeFlags() {
            return new MergeFlags();
        }

        public boolean simulate() {
            return this.simulate;
        }

        public MergeFlags simulate(boolean simulate) {
            this.simulate = simulate;
            return this;
        }
    }

    public static class MergeResult {
        private final String[] conflicts;

        public MergeResult(String[] conflicts) {
            this.conflicts = conflicts;
        }

        public boolean hasConflicts() {
            return this.conflicts.length > 0;
        }

        public String[] conflicts() {
            return this.conflicts;
        }
    }
}

