/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.memory.CustomMemoryIndex;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.percolator.PercolateIndexUnavailable;
import org.elasticsearch.index.percolator.PercolatorException;
import org.elasticsearch.index.query.IndexQueryParser;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.xcontent.QueryBuilders;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;

public class PercolatorExecutor
extends AbstractIndexComponent {
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final IndexCache indexCache;
    private volatile ImmutableMap<String, Query> queries = ImmutableMap.of();
    private IndicesService indicesService;

    @Inject
    public PercolatorExecutor(Index index, @IndexSettings Settings indexSettings, MapperService mapperService, IndexQueryParserService queryParserService, IndexCache indexCache) {
        super(index, indexSettings);
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.indexCache = indexCache;
    }

    public void setIndicesService(IndicesService indicesService) {
        this.indicesService = indicesService;
    }

    public synchronized void close() {
        ImmutableMap<String, Query> old = this.queries;
        this.queries = ImmutableMap.of();
        old.clear();
    }

    public void addQuery(String name, QueryBuilder queryBuilder) throws ElasticSearchException {
        try {
            XContentBuilder builder = XContentFactory.smileBuilder().startObject().field("query", (Object)queryBuilder).endObject();
            BytesStream unsafeBytes = builder.unsafeStream();
            this.addQuery(name, unsafeBytes.unsafeByteArray(), 0, unsafeBytes.size());
        }
        catch (IOException e) {
            throw new ElasticSearchException("Failed to add query [" + name + "]", e);
        }
    }

    public void addQuery(String name, byte[] source) throws ElasticSearchException {
        this.addQuery(name, source, 0, source.length);
    }

    public void addQuery(String name, byte[] source, int sourceOffset, int sourceLength) throws ElasticSearchException {
        this.addQuery(name, this.parseQuery(name, source, sourceOffset, sourceLength));
    }

    public Query parseQuery(String name, byte[] source, int sourceOffset, int sourceLength) throws ElasticSearchException {
        XContentParser parser = null;
        try {
            XContentParser.Token token;
            parser = XContentFactory.xContent(source, sourceOffset, sourceLength).createParser(source, sourceOffset, sourceLength);
            Query query = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT || !"query".equals(currentFieldName)) continue;
                IndexQueryParser queryParser = this.queryParserService.defaultIndexQueryParser();
                query = queryParser.parse(parser).query();
            }
            Query query2 = query;
            return query2;
        }
        catch (IOException e) {
            throw new ElasticSearchException("Failed to add query [" + name + "]", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    public synchronized void addQuery(String name, Query query) {
        Preconditions.checkArgument(query != null, "query must be provided for percolate request");
        this.queries = MapBuilder.newMapBuilder(this.queries).put(name, query).immutableMap();
    }

    public synchronized void removeQuery(String name) {
        this.queries = MapBuilder.newMapBuilder(this.queries).remove(name).immutableMap();
    }

    public synchronized void addQueries(Map<String, Query> queries) {
        this.queries = MapBuilder.newMapBuilder(this.queries).putAll(queries).immutableMap();
    }

    public Response percolate(SourceRequest request) throws ElasticSearchException {
        Query query = null;
        ParsedDocument doc = null;
        XContentParser parser = null;
        try {
            XContentParser.Token token;
            parser = XContentFactory.xContent(request.source(), request.offset(), request.length()).createParser(request.source(), request.offset(), request.length());
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (!"doc".equals(currentFieldName)) continue;
                    DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(request.type());
                    doc = docMapper.parse(SourceToParse.source(parser).type(request.type()).flyweight(true));
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (!"query".equals(currentFieldName)) continue;
                    IndexQueryParser queryParser = this.queryParserService.defaultIndexQueryParser();
                    query = queryParser.parse(parser).query();
                    continue;
                }
                if (token != null) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new PercolatorException(this.index, "failed to parse request", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        if (doc == null) {
            throw new PercolatorException(this.index, "No doc to percolate in the request");
        }
        return this.percolate(new DocAndQueryRequest(doc, query));
    }

    public Response percolate(DocAndSourceQueryRequest request) throws ElasticSearchException {
        Query query = null;
        if (Strings.hasLength(request.query()) && !request.query().equals("*")) {
            IndexQueryParser queryParser = this.queryParserService.defaultIndexQueryParser();
            query = queryParser.parse(QueryBuilders.queryString(request.query())).query();
        }
        return this.percolate(new DocAndQueryRequest(request.doc(), query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response percolate(DocAndQueryRequest request) throws ElasticSearchException {
        CustomMemoryIndex memoryIndex = new CustomMemoryIndex();
        for (Fieldable field : request.doc().doc().getFields()) {
            if (!field.isIndexed() || field.name().equals("_uid")) continue;
            TokenStream tokenStream = field.tokenStreamValue();
            if (tokenStream != null) {
                memoryIndex.addField(field.name(), tokenStream, field.getBoost());
                continue;
            }
            Reader reader = field.readerValue();
            if (reader != null) {
                try {
                    memoryIndex.addField(field.name(), request.doc().analyzer().reusableTokenStream(field.name(), reader), field.getBoost() * request.doc().doc().getBoost());
                    continue;
                }
                catch (IOException e) {
                    throw new MapperParsingException("Failed to analyze field [" + field.name() + "]", e);
                }
            }
            String value = field.stringValue();
            if (value == null) continue;
            try {
                memoryIndex.addField(field.name(), request.doc().analyzer().reusableTokenStream(field.name(), (Reader)new FastStringReader(value)), field.getBoost() * request.doc().doc().getBoost());
            }
            catch (IOException e) {
                throw new MapperParsingException("Failed to analyze field [" + field.name() + "]", e);
            }
        }
        IndexSearcher searcher = memoryIndex.createSearcher();
        ArrayList<String> matches = new ArrayList<String>();
        if (request.query() == null) {
            Lucene.ExistsCollector collector = new Lucene.ExistsCollector();
            for (Map.Entry entry : this.queries.entrySet()) {
                collector.reset();
                try {
                    searcher.search((Query)entry.getValue(), (Collector)collector);
                }
                catch (IOException e) {
                    this.logger.warn("[" + (String)entry.getKey() + "] failed to execute query", e, new Object[0]);
                }
                if (!collector.exists()) continue;
                matches.add((String)entry.getKey());
            }
        } else {
            IndexService percolatorIndex = this.indicesService.indexService("_percolator");
            if (percolatorIndex == null) {
                throw new PercolateIndexUnavailable(new Index("_percolator"));
            }
            if (percolatorIndex.numberOfShards() == 0) {
                throw new PercolateIndexUnavailable(new Index("_percolator"));
            }
            IndexShard percolatorShard = percolatorIndex.shard(0);
            Engine.Searcher percolatorSearcher = percolatorShard.searcher();
            try {
                percolatorSearcher.searcher().search(request.query(), new QueryCollector(this.logger, this.queries, searcher, percolatorIndex, matches));
            }
            catch (IOException e) {
                this.logger.warn("failed to execute", e, new Object[0]);
            }
            finally {
                percolatorSearcher.release();
            }
        }
        this.indexCache.clear(searcher.getIndexReader());
        return new Response(matches, request.doc().mappersAdded());
    }

    static class QueryCollector
    extends Collector {
        private final IndexSearcher searcher;
        private final IndexService percolatorIndex;
        private final List<String> matches;
        private final ImmutableMap<String, Query> queries;
        private final ESLogger logger;
        private final Lucene.ExistsCollector collector = new Lucene.ExistsCollector();
        private FieldData fieldData;

        QueryCollector(ESLogger logger, ImmutableMap<String, Query> queries, IndexSearcher searcher, IndexService percolatorIndex, List<String> matches) {
            this.logger = logger;
            this.queries = queries;
            this.searcher = searcher;
            this.percolatorIndex = percolatorIndex;
            this.matches = matches;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            String uid = this.fieldData.stringValue(doc);
            if (uid == null) {
                return;
            }
            String id = Uid.idFromUid(uid);
            Query query = this.queries.get(id);
            if (query == null) {
                return;
            }
            try {
                this.searcher.search(query, (Collector)this.collector);
                if (this.collector.exists()) {
                    this.matches.add(id);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + id + "] failed to execute query", e, new Object[0]);
            }
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.fieldData = this.percolatorIndex.cache().fieldData().cache(FieldDataType.DefaultTypes.STRING, reader, "_uid");
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    public static final class Response {
        private final List<String> matches;
        private final boolean mappersAdded;

        public Response(List<String> matches, boolean mappersAdded) {
            this.matches = matches;
            this.mappersAdded = mappersAdded;
        }

        public boolean mappersAdded() {
            return this.mappersAdded;
        }

        public List<String> matches() {
            return this.matches;
        }
    }

    public static class DocAndQueryRequest {
        private final ParsedDocument doc;
        @Nullable
        private final Query query;

        public DocAndQueryRequest(ParsedDocument doc, @Nullable Query query) {
            this.doc = doc;
            this.query = query;
        }

        public ParsedDocument doc() {
            return this.doc;
        }

        @Nullable
        Query query() {
            return this.query;
        }
    }

    public static class DocAndSourceQueryRequest {
        private final ParsedDocument doc;
        @Nullable
        private final String query;

        public DocAndSourceQueryRequest(ParsedDocument doc, @Nullable String query) {
            this.doc = doc;
            this.query = query;
        }

        public ParsedDocument doc() {
            return this.doc;
        }

        @Nullable
        String query() {
            return this.query;
        }
    }

    public static class SourceRequest {
        private final String type;
        private final byte[] source;
        private final int offset;
        private final int length;

        public SourceRequest(String type, byte[] source) {
            this(type, source, 0, source.length);
        }

        public SourceRequest(String type, byte[] source, int offset, int length) {
            this.type = type;
            this.source = source;
            this.offset = offset;
            this.length = length;
        }

        public String type() {
            return this.type;
        }

        public byte[] source() {
            return this.source;
        }

        public int offset() {
            return this.offset;
        }

        public int length() {
            return this.length;
        }
    }
}

