/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilderException;
import org.elasticsearch.index.query.xcontent.XContentQueryBuilder;

public abstract class BaseQueryBuilder
implements XContentQueryBuilder {
    @Override
    public BytesStream buildAsUnsafeBytes() throws QueryBuilderException {
        return this.buildAsUnsafeBytes(XContentType.JSON);
    }

    @Override
    public BytesStream buildAsUnsafeBytes(XContentType contentType) throws QueryBuilderException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            this.toXContent(builder, EMPTY_PARAMS);
            return builder.unsafeStream();
        }
        catch (Exception e) {
            throw new QueryBuilderException("Failed to build query", e);
        }
    }

    @Override
    public byte[] buildAsBytes() throws QueryBuilderException {
        return this.buildAsBytes(XContentType.JSON);
    }

    @Override
    public byte[] buildAsBytes(XContentType contentType) throws QueryBuilderException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            this.toXContent(builder, EMPTY_PARAMS);
            return builder.copiedBytes();
        }
        catch (Exception e) {
            throw new QueryBuilderException("Failed to build query", e);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
}

