/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldDataType;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentFilterParser;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.index.search.geo.GeoDistanceFilter;
import org.elasticsearch.index.search.geo.GeoHashUtils;
import org.elasticsearch.index.settings.IndexSettings;

public class GeoDistanceFilterParser
extends AbstractIndexComponent
implements XContentFilterParser {
    public static final String NAME = "geo_distance";

    @Inject
    public GeoDistanceFilterParser(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoDistance"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        String filterName = null;
        String currentFieldName = null;
        double lat = 0.0;
        double lon = 0.0;
        String fieldName = null;
        double distance = 0.0;
        Object vDistance = null;
        DistanceUnit unit = DistanceUnit.KILOMETERS;
        GeoDistance geoDistance = GeoDistance.ARC;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                token = parser.nextToken();
                lon = parser.doubleValue();
                token = parser.nextToken();
                lat = parser.doubleValue();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                }
                fieldName = currentFieldName;
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                String currentName = parser.currentName();
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if (currentName.equals("lat")) {
                        lat = parser.doubleValue();
                        continue;
                    }
                    if (currentName.equals("lon")) {
                        lon = parser.doubleValue();
                        continue;
                    }
                    if (!currentName.equals("geohash")) continue;
                    double[] values = GeoHashUtils.decode(parser.text());
                    lat = values[0];
                    lon = values[1];
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (currentFieldName.equals("distance")) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    vDistance = parser.text();
                    continue;
                }
                vDistance = parser.numberValue();
                continue;
            }
            if (currentFieldName.equals("unit")) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (currentFieldName.equals("distance_type") || currentFieldName.equals("distanceType")) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if (currentFieldName.endsWith(".lat")) {
                lat = parser.doubleValue();
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lat".length());
                continue;
            }
            if (currentFieldName.endsWith(".lon")) {
                lon = parser.doubleValue();
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lon".length());
                continue;
            }
            if (currentFieldName.endsWith(".geohash")) {
                double[] values = GeoHashUtils.decode(parser.text());
                lat = values[0];
                lon = values[1];
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".geohash".length());
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            String value = parser.text();
            int comma = value.indexOf(44);
            if (comma != -1) {
                lat = Double.parseDouble(value.substring(0, comma).trim());
                lon = Double.parseDouble(value.substring(comma + 1).trim());
            } else {
                double[] values = GeoHashUtils.decode(value);
                lat = values[0];
                lon = values[1];
            }
            fieldName = currentFieldName;
        }
        distance = vDistance instanceof Number ? unit.toMiles(((Number)vDistance).doubleValue()) : DistanceUnit.parse((String)vDistance, unit, DistanceUnit.MILES);
        MapperService mapperService = parseContext.mapperService();
        FieldMapper mapper = mapperService.smartNameFieldMapper(fieldName);
        if (mapper == null) {
            throw new QueryParsingException(this.index, "failed to find geo_point field [" + fieldName + "]");
        }
        if (mapper.fieldDataType() != GeoPointFieldDataType.TYPE) {
            throw new QueryParsingException(this.index, "field [" + fieldName + "] is not a geo_point field");
        }
        fieldName = mapper.names().indexName();
        GeoDistanceFilter filter = new GeoDistanceFilter(lat, lon, distance, geoDistance, fieldName, parseContext.indexCache().fieldData());
        if (cache) {
            filter = parseContext.cacheFilter(filter);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, parseContext.smartFieldMappers(fieldName), parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

