/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentFilterParser;
import org.elasticsearch.index.settings.IndexSettings;

public class TypeFilterParser
extends AbstractIndexComponent
implements XContentFilterParser {
    public static final String NAME = "type";

    @Inject
    public TypeFilterParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(this.index, "type filter should have a value field, and the type name");
        }
        String fieldName = parser.currentName();
        if (!fieldName.equals("value")) {
            throw new QueryParsingException(this.index, "type filter should have a value field, and the type name");
        }
        token = parser.nextToken();
        if (token != XContentParser.Token.VALUE_STRING) {
            throw new QueryParsingException(this.index, "type filter should have a value field, and the type name");
        }
        String type = parser.text();
        parser.nextToken();
        DocumentMapper documentMapper = parseContext.mapperService().documentMapper(type);
        Filter filter = documentMapper == null ? new TermFilter(new Term("_type", type)) : documentMapper.typeFilter();
        return parseContext.cacheFilter(filter);
    }
}

