/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import org.elasticsearch.common.component.CloseableComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.IndexServiceManagement;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.jmx.JmxService;
import org.elasticsearch.jmx.MBean;
import org.elasticsearch.jmx.ManagedAttribute;

@MBean(objectName="", description="")
public class IndexShardManagement
extends AbstractIndexShardComponent
implements CloseableComponent {
    private final JmxService jmxService;
    private final IndexShard indexShard;
    private final Store store;
    private final Translog translog;

    public static String buildShardGroupName(ShardId shardId) {
        return IndexServiceManagement.buildIndexGroupName(shardId.index()) + ",subService=shards,shard=" + shardId.id();
    }

    @Inject
    public IndexShardManagement(ShardId shardId, @IndexSettings Settings indexSettings, JmxService jmxService, IndexShard indexShard, Store store, Translog translog) {
        super(shardId, indexSettings);
        this.jmxService = jmxService;
        this.indexShard = indexShard;
        this.store = store;
        this.translog = translog;
    }

    @Override
    public void close() {
        this.jmxService.unregisterGroup(IndexShardManagement.buildShardGroupName(this.indexShard.shardId()));
    }

    @ManagedAttribute(description="Index Name")
    public String getIndex() {
        return this.indexShard.shardId().index().name();
    }

    @ManagedAttribute(description="Shard Id")
    public int getShardId() {
        return this.indexShard.shardId().id();
    }

    @ManagedAttribute(description="Storage Size")
    public String getStoreSize() {
        try {
            return this.store.estimateSize().toString();
        }
        catch (IOException e) {
            return "NA";
        }
    }

    @ManagedAttribute(description="The current transaction log id")
    public long getTranslogId() {
        return this.translog.currentId();
    }

    @ManagedAttribute(description="Number of transaction log operations")
    public long getTranslogNumberOfOperations() {
        return this.translog.numberOfOperations();
    }

    @ManagedAttribute(description="Estimated size in memory the transaction log takes")
    public String getTranslogSize() {
        return new ByteSizeValue(this.translog.memorySizeInBytes()).toString();
    }

    @ManagedAttribute(description="The state of the shard")
    public String getState() {
        return this.indexShard.state().toString();
    }

    @ManagedAttribute(description="Primary")
    public boolean isPrimary() {
        return this.indexShard.routingEntry().primary();
    }

    @ManagedAttribute(description="The state of the shard as perceived by the cluster")
    public String getRoutingState() {
        return this.indexShard.routingEntry().state().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="The number of documents in the index")
    public int getNumDocs() {
        Engine.Searcher searcher = this.indexShard.searcher();
        try {
            int n = searcher.reader().numDocs();
            return n;
        }
        finally {
            searcher.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="The total number of documents in the index (including deleted ones)")
    public int getMaxDoc() {
        Engine.Searcher searcher = this.indexShard.searcher();
        try {
            int n = searcher.reader().maxDoc();
            return n;
        }
        finally {
            searcher.release();
        }
    }
}

