/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.io.FileChannelInputStream;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.RafReference;

public class FsChannelSnapshot
implements Translog.Snapshot {
    private final ShardId shardId;
    private final long id;
    private final int totalOperations;
    private final int snapshotOperations;
    private final RafReference raf;
    private final FileChannel channel;
    private final long length;
    private Translog.Operation lastOperationRead = null;
    private int position = 0;
    private ByteBuffer cacheBuffer;

    public FsChannelSnapshot(ShardId shardId, long id, RafReference raf, long length, int totalOperations, int snapshotOperations) throws FileNotFoundException {
        this.shardId = shardId;
        this.id = id;
        this.raf = raf;
        this.channel = raf.raf().getChannel();
        this.length = length;
        this.totalOperations = totalOperations;
        this.snapshotOperations = snapshotOperations;
    }

    @Override
    public long translogId() {
        return this.id;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    public int snapshotOperations() {
        return this.snapshotOperations;
    }

    @Override
    public InputStream stream() throws IOException {
        return new FileChannelInputStream(this.channel, this.position, this.lengthInBytes());
    }

    @Override
    public long lengthInBytes() {
        return this.length - (long)this.position;
    }

    @Override
    public boolean hasNext() {
        try {
            if ((long)this.position > this.length) {
                return false;
            }
            if (this.cacheBuffer == null) {
                this.cacheBuffer = ByteBuffer.allocate(1024);
            }
            this.cacheBuffer.limit(4);
            int bytesRead = this.channel.read(this.cacheBuffer, this.position);
            if (bytesRead < 4) {
                return false;
            }
            this.cacheBuffer.flip();
            int opSize = this.cacheBuffer.getInt();
            this.position += 4;
            if ((long)(this.position + opSize) > this.length) {
                this.position -= 4;
                return false;
            }
            if (this.cacheBuffer.capacity() < opSize) {
                this.cacheBuffer = ByteBuffer.allocate(opSize);
            }
            this.cacheBuffer.clear();
            this.cacheBuffer.limit(opSize);
            this.channel.read(this.cacheBuffer, this.position);
            this.cacheBuffer.flip();
            this.position += opSize;
            this.lastOperationRead = TranslogStreams.readTranslogOperation(new BytesStreamInput(this.cacheBuffer.array(), 0, opSize));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Translog.Operation next() {
        return this.lastOperationRead;
    }

    @Override
    public void seekForward(long length) {
        this.position = (int)((long)this.position + length);
    }

    @Override
    public boolean release() throws ElasticSearchException {
        this.raf.decreaseRefCount(true);
        return true;
    }
}

