/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestGetMappingAction
extends BaseRestHandler {
    @Inject
    public RestGetMappingAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mapping", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        final String[] indices = RestActions.splitIndices(request.param("index"));
        final ImmutableSet<String> types = ImmutableSet.copyOf(RestActions.splitTypes(request.param("type")));
        ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest().filterRoutingTable(true).filterNodes(true).filteredIndices(indices);
        this.client.admin().cluster().state(clusterStateRequest, new ActionListener<ClusterStateResponse>(){

            @Override
            public void onResponse(ClusterStateResponse response) {
                try {
                    MetaData metaData = response.state().metaData();
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    if (indices.length == 1 && types.size() == 1) {
                        IndexMetaData indexMetaData = (IndexMetaData)metaData.iterator().next();
                        for (MappingMetaData mappingMd : indexMetaData.mappings().values()) {
                            if (!types.isEmpty() && !types.contains(mappingMd.type())) continue;
                            byte[] mappingSource = mappingMd.source().uncompressed();
                            XContentParser parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);
                            Map mapping = parser.map();
                            if (mapping.size() == 1 && mapping.containsKey(mappingMd.type())) {
                                mapping = (Map)mapping.get(mappingMd.type());
                            }
                            builder.field(mappingMd.type());
                            builder.map(mapping);
                        }
                    } else {
                        for (IndexMetaData indexMetaData : metaData) {
                            builder.startObject(indexMetaData.index());
                            for (MappingMetaData mappingMd : indexMetaData.mappings().values()) {
                                if (!types.isEmpty() && !types.contains(mappingMd.type())) continue;
                                byte[] mappingSource = mappingMd.source().uncompressed();
                                XContentParser parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);
                                Map mapping = parser.map();
                                if (mapping.size() == 1 && mapping.containsKey(mappingMd.type())) {
                                    mapping = (Map)mapping.get(mappingMd.type());
                                }
                                builder.field(mappingMd.type());
                                builder.map(mapping);
                            }
                            builder.endObject();
                        }
                    }
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestGetMappingAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

